package com.samsthenerd.inline.impl.extrahooks;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.samsthenerd.inline.api.client.extrahooks.ItemOverlayRenderer;
import com.samsthenerd.inline.utils.VCPImmediateButImLyingAboutIt;
import org.joml.Matrix4f;

import java.util.*;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class ItemOverlayManager {
    private static final Map<Item, List<ItemOverlayRenderer>> ITEM_RENDERERS = new HashMap<>();
    private static final Set<ItemOverlayRenderer> GLOBAL_RENDERERS = new HashSet<>();

    public static List<ItemOverlayRenderer> getRenderers(Item item){
        var renderers = new ArrayList<>(ITEM_RENDERERS.getOrDefault(item, List.of()));
        renderers.addAll(GLOBAL_RENDERERS);
        return renderers;
    }

    public static void addRenderer(Item item, ItemOverlayRenderer renderer){
        ITEM_RENDERERS.computeIfAbsent(item, it -> new ArrayList<>()).add(renderer);
    }

    public static void addRenderer(ItemOverlayRenderer renderer){
        GLOBAL_RENDERERS.add(renderer);
    }

    public static void removeRenderer(ItemOverlayRenderer renderer){
        GLOBAL_RENDERERS.remove(renderer);
    }

    public static void renderDetailTexture(ItemStack stack, PoseStack matrices,
                                           ItemDisplayContext renderMode, MultiBufferSource vertexConsumers,
                                           int light, int overlay, boolean leftHanded){
        if(renderMode != ItemDisplayContext.GUI) return;
        var renderers = ItemOverlayManager.getRenderers(stack.m_41720_());
        for(var overlayRenderer : renderers) {

            if(!overlayRenderer.isActive(stack)) continue;

            boolean overItem = overlayRenderer.renderInFront(stack);
            MultiBufferSource.BufferSource immVC;
            if (overItem && vertexConsumers instanceof MultiBufferSource.BufferSource immediateVCs) {
                RenderSystem.disableDepthTest();
                immediateVCs.m_109911_();
                RenderSystem.enableDepthTest();
                immVC = immediateVCs;
            } else {
                immVC = VCPImmediateButImLyingAboutIt.of(vertexConsumers);
            }

            GuiGraphics drawCtx = new GuiGraphics(Minecraft.m_91087_(), immVC);
            PoseStack ctxMat = drawCtx.m_280168_();
            ctxMat.m_85836_();
            ctxMat.m_252931_(matrices.m_85850_().m_252922_());
            ctxMat.m_85841_(1f/16, -1f/16, 1f/16);
            ctxMat.m_252880_(0, -16, overItem ? 10 : -100);
            overlayRenderer.render(stack, drawCtx);
            ctxMat.m_85849_();
        }
    }
}
