package com.samsthenerd.inline.api.client.renderers;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.client.GlowHandling;
import com.samsthenerd.inline.api.client.InlineRenderer;
import com.samsthenerd.inline.api.data.ItemInlineData;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;

public class InlineItemRenderer implements InlineRenderer<ItemInlineData>{

    public static final InlineItemRenderer INSTANCE = new InlineItemRenderer();

    public ResourceLocation getId(){
        return new ResourceLocation(Inline.MOD_ID, "item");
    }

    public static boolean debugEarlyReturn = true;

    public int render(ItemInlineData data, GuiGraphics context, int index, Style style, int codepoint, TextRenderingContext trContext){
        // only draw it once
        if(trContext.shadow()){
            return 8;
        }
        PoseStack matrices = context.m_280168_();
        
        // context.drawItem(data.getStack(), 0, 0);
        // matrices.pop();

        ItemStack stack = data.getStack();
        Minecraft client = Minecraft.m_91087_();
        Level world = client.f_91073_;

        if (stack.m_41619_()) {
            return 8;
        }
        BakedModel bakedModel = client.m_91291_().m_174264_(stack, world, null, 0);
        boolean flat = !bakedModel.m_7547_();
        /*
         * here we do a bunch of garbage to make lighting work as nicely as possible in-game.
         *
         * the main issue is that DiffuseLighting.disableGuiDepthLighting() messes up the game's lighting but is needed
         * to make an item look Right when rendered in a flat UI.
         *
         * First we check that it's flat and that the layer type is normal (all UI text rendering seems to use this?)
         * Then we check that the position matrix at the top is flat.
         */
        if (flat && InlineRenderer.isFlat(matrices, trContext.layerType())) {
            Lighting.m_84930_();
        }
        matrices.m_85836_();
        matrices.m_252880_(4, 4, 0);
        try {
            matrices.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
            matrices.m_85841_(8.0f, 8.0f, 8f);
            client.m_91291_().m_115143_(stack, ItemDisplayContext.GUI, false, matrices, context.m_280091_(), trContext.light(), OverlayTexture.f_118083_, bakedModel);
            context.m_280091_().m_109911_();
        } catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.m_127521_(throwable, "Rendering item");
            CrashReportCategory crashReportSection = crashReport.m_127514_("Item being rendered");
            crashReportSection.m_128165_("Item Type", () -> String.valueOf(stack.m_41720_()));
            crashReportSection.m_128165_("Item Damage", () -> String.valueOf(stack.m_41773_()));
            crashReportSection.m_128165_("Item NBT", () -> String.valueOf(stack.m_41783_()));
            crashReportSection.m_128165_("Item Foil", () -> String.valueOf(stack.m_41790_()));
            throw new ReportedException(crashReport);
        }
        matrices.m_85849_();
        return 8;
    }

    public int charWidth(ItemInlineData data, Style style, int codepoint){
        return 8;
    }

    // TODO: handle animated items ehre
    @Override
    public GlowHandling getGlowPreference(ItemInlineData forData){
        // this nonsense should force it to refresh for animated sprites ?
        BakedModel bakedModel = Minecraft.m_91087_().m_91291_().m_174264_(forData.getStack(), Minecraft.m_91087_().f_91073_, null, 0);
        return new GlowHandling.Full(forData.getStack().m_41778_() + Integer.toHexString(bakedModel.hashCode()));
    }
}
