package com.samsthenerd.inline.api.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.client.GlowHandling;
import com.samsthenerd.inline.api.client.InlineRenderer;
import com.samsthenerd.inline.api.data.EntityInlineData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class InlineEntityRenderer implements InlineRenderer<EntityInlineData>{

    public static final InlineEntityRenderer INSTANCE = new InlineEntityRenderer();

    public ResourceLocation getId(){
        return new ResourceLocation(Inline.MOD_ID, "entity");
    }

    public int render(EntityInlineData data, GuiGraphics context, int index, Style style, int codepoint, TextRenderingContext trContext){
        // only draw it once
        Entity ent = data.getEntity(Minecraft.m_91087_().f_91073_);
        if(ent == null) return 0;

        float width = ent.m_20205_();
        float height = ent.m_20206_();

        float rot = 15f;
        double radRot = Math.toRadians(rot % 90);
        double pWidth = width * (Math.cos(radRot)+Math.sin(radRot));

        int cDist = (int)Math.ceil(pWidth * 8 / height) + 1;
        if(trContext.shadow()){
            return cDist;
        }
        EntityRenderer renderer = Minecraft.m_91087_().m_91290_().m_114382_(ent);
        PoseStack matrices = context.m_280168_();
        matrices.m_85837_(cDist/2.0, 8, 0);
        matrices.m_85841_(8 / height, -8 / height, 8 / height);
        Minecraft.m_91087_().m_91296_();
        Minecraft client = Minecraft.m_91087_();
        float tickDelta = client.m_91296_();
        // float rotation = 90f * (Util.getMeasuringTimeMs() / 1000f + data.getUniqueOffset());
        matrices.m_252781_(Axis.f_252436_.m_252977_(rot));
        renderer.m_7392_(ent, 0, 0, matrices, context.m_280091_(), trContext.light());
        return cDist;
    }

    public int charWidth(EntityInlineData data, Style style, int codepoint){
        Entity ent = data.getEntity(Minecraft.m_91087_().f_91073_);
        if(ent == null) return 0;
        float width = ent.m_20205_();
        float height = ent.m_20206_();

        float rot = 15f;
        double radRot = Math.toRadians(rot % 90);
        double pWidth = width * (Math.cos(radRot)+Math.sin(radRot));

        return (int)Math.ceil(pWidth * 8 / height) + 1;
    }

    @Override
    public GlowHandling getGlowPreference(EntityInlineData forData){ return new GlowHandling.Full(forData.cradle.getId()); }
}
