package com.samsthenerd.inline.utils.cradles;

import com.mojang.serialization.Codec;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.utils.EntityCradle;
import com.samsthenerd.inline.utils.FakeClientPlayerMaker;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_9296;

/**
 * An entity cradle backed by a player GameProfile
 */
public class PlayerCradle extends EntityCradle {

    private final class_9296 profile;

    public PlayerCradle(class_9296 profile){
        this.profile = profile;
    }

    public class_9296 getProfile(){
        return profile;
    }

    public CradleType<?> getType(){
        return PlayerCradleType.INSTANCE;
    }

    @Override
    public String getId(){
        return profile.comp_2411().map(Object::toString).orElseGet(() -> profile.comp_2410().get());
    }

    public class_1297 getEntity(class_1937 world){
        return FakeClientPlayerMaker.getPlayerEntity(profile);
    }

    private static class PlayerCradleType implements CradleType<PlayerCradle>{

        public static PlayerCradleType INSTANCE = EntityCradle.addCradleType(new PlayerCradleType());

        public class_2960 getId(){
            return Inline.id( "nbt");
        }

        public Codec<PlayerCradle> getCodec(){
            return class_9296.field_49359.xmap(
                PlayerCradle::new,
                PlayerCradle::getProfile
            );
        }
    }
}
