package com.samsthenerd.inline.api.data;


import com.mojang.serialization.Codec;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.tooltips.CustomTooltipManager;
import com.samsthenerd.inline.tooltips.providers.EntityTTProvider;
import com.samsthenerd.inline.utils.cradles.PlayerCradle;
import java.util.Objects;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_9296;

public class PlayerHeadData implements InlineData<PlayerHeadData> {
    private class_9296 profile;

    public PlayerHeadData(class_9296 profile) {
        this.profile = profile;
    }

    @Override
    public PlayerHeadDataType getType() {
        return PlayerHeadDataType.INSTANCE;
    }

    @Override
    public class_2960 getRendererId() {
        return Inline.id("playerhead");
    }

    public class_2568 getEntityDisplayHoverEvent() {
        return new class_2568(
          class_2568.class_5247.field_24343,
          new class_2568.class_5249(CustomTooltipManager.getForTooltip(EntityTTProvider.INSTANCE, new PlayerCradle(profile())))
        );
    }

    public class_2583 getDataStyle(boolean withAdditional) {
        class_2583 superStyle = InlineData.super.asStyle(withAdditional);
        if (!withAdditional) return superStyle;
        return superStyle.method_27702(class_2583.field_24360.method_10949(getEntityDisplayHoverEvent()));
    }

    public class_9296 profile() {
        if (!profile.method_57511()) {
            profile.method_57507().thenAcceptAsync(profileComponent -> {
                profile = profileComponent;
            });
        }
        return profile;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (obj == null || obj.getClass() != this.getClass()) return false;
        var that = (PlayerHeadData) obj;
        return Objects.equals(this.profile, that.profile);
    }

    @Override
    public int hashCode() {
        return Objects.hash(profile);
    }

    @Override
    public String toString() {
        return "PlayerHeadData[" +
               "profile=" + profile + ']';
    }


    public static class PlayerHeadDataType implements InlineDataType<PlayerHeadData> {
        public static PlayerHeadDataType INSTANCE = new PlayerHeadDataType();

        @Override
        public class_2960 getId() {
            return Inline.id("playerhead");
        }

        @Override
        public Codec<PlayerHeadData> getCodec() {
            return class_9296.field_49359.xmap(PlayerHeadData::new, data -> data.profile);
        }
    }
}
