package com.samsthenerd.inline.api.client.renderers;

import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.client.GlowHandling;
import com.samsthenerd.inline.api.client.InlineRenderer;
import com.samsthenerd.inline.api.data.EntityInlineData;
import net.minecraft.class_1297;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_7833;
import net.minecraft.class_897;

public class InlineEntityRenderer implements InlineRenderer<EntityInlineData>{

    public static final InlineEntityRenderer INSTANCE = new InlineEntityRenderer();

    public class_2960 getId(){
        return Inline.id( "entity");
    }

    public int render(EntityInlineData data, class_332 context, int index, class_2583 style, int codepoint, TextRenderingContext trContext){
        // only draw it once
        class_1297 ent = data.getEntity(class_310.method_1551().field_1687);
        if(ent == null) return 0;

        float width = ent.method_17681();
        float height = ent.method_17682();

        float rot = 15f;
        double radRot = Math.toRadians(rot % 90);
        double pWidth = width * (Math.cos(radRot)+Math.sin(radRot));

        int cDist = (int)Math.ceil(pWidth * 8 / height) + 1;
        if(trContext.shadow()){
            return cDist;
        }
        class_897 renderer = class_310.method_1551().method_1561().method_3953(ent);
        class_4587 matrices = context.method_51448();
        matrices.method_22904(cDist/2.0, 8, 0);
        matrices.method_22905(8 / height, -8 / height, 8 / height);
        // float rotation = 90f * (Util.getMeasuringTimeMs() / 1000f + data.getUniqueOffset());
        matrices.method_22907(class_7833.field_40716.rotationDegrees(rot));
        renderer.method_3936(ent, 0, 0, matrices, context.method_51450(), trContext.light());
        return cDist;
    }

    public int charWidth(EntityInlineData data, class_2583 style, int codepoint){
        class_1297 ent = data.getEntity(class_310.method_1551().field_1687);
        if(ent == null) return 0;
        float width = ent.method_17681();
        float height = ent.method_17682();

        float rot = 15f;
        double radRot = Math.toRadians(rot % 90);
        double pWidth = width * (Math.cos(radRot)+Math.sin(radRot));

        return (int)Math.ceil(pWidth * 8 / height) + 1;
    }

    @Override
    public GlowHandling getGlowPreference(EntityInlineData forData){ return new GlowHandling.Full(forData.cradle.getId()); }
}
