package com.samsthenerd.inline.api.data;


import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Codec;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.tooltips.CustomTooltipManager;
import com.samsthenerd.inline.tooltips.providers.EntityTTProvider;
import com.samsthenerd.inline.utils.cradles.PlayerCradle;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;

public class PlayerHeadData implements InlineData<PlayerHeadData>{

    @Override
    public PlayerHeadDataType getType(){
        return PlayerHeadDataType.INSTANCE;
    }

    @Override
    public class_2960 getRendererId(){
        return new class_2960(Inline.MOD_ID, "playerhead");
    }

    public final GameProfile profile;

    public PlayerHeadData(GameProfile profile){
        this.profile = profile;
    }

    public class_2568 getEntityDisplayHoverEvent(){
        return new class_2568(
            class_2568.class_5247.field_24343, 
            new class_2568.class_5249(CustomTooltipManager.getForTooltip(EntityTTProvider.INSTANCE, new PlayerCradle(profile)))
        ); 
    }

    public class_2583 getDataStyle(boolean withAdditional){
        class_2583 superStyle = InlineData.super.asStyle(withAdditional);
        if(!withAdditional) return superStyle;
        return superStyle.method_27702(class_2583.field_24360.method_10949(getEntityDisplayHoverEvent()));
    }

    public static class PlayerHeadDataType implements InlineDataType<PlayerHeadData> {
        public static PlayerHeadDataType INSTANCE = new PlayerHeadDataType();

        @Override
        public class_2960 getId(){
            return new class_2960(Inline.MOD_ID, "playerhead");
        }

        private static Gson GSON = new GsonBuilder().create();

        @Override
        public Codec<PlayerHeadData> getCodec(){
            return PlayerCradle.GAME_PROFILE_CODEC.xmap(PlayerHeadData::new, data -> data.profile);
        }

        public PlayerHeadData deserialize(JsonElement json){
            return new PlayerHeadData(GSON.fromJson(json, GameProfile.class));
        }

        public JsonElement serializeData(PlayerHeadData data){
            GameProfile profile = ((PlayerHeadData)data).profile;
            return GSON.toJsonTree(profile);
        }
    }
}
