package com.samsthenerd.inline;

import java.util.Optional;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import com.samsthenerd.inline.api.client.InlineClientAPI;
import com.samsthenerd.inline.api.client.extrahooks.ItemOverlayRenderer;
import com.samsthenerd.inline.api.data.*;
import com.samsthenerd.inline.api.matching.InlineMatch.DataMatch;
import com.samsthenerd.inline.api.matching.InlineMatch.TextMatch;
import com.samsthenerd.inline.api.matching.MatcherInfo;
import com.samsthenerd.inline.api.matching.RegexMatcher;
import com.samsthenerd.inline.api.matching.RegexMatcher.Standard;
import com.samsthenerd.inline.api.client.renderers.InlineEntityRenderer;
import com.samsthenerd.inline.api.client.renderers.InlineItemRenderer;
import com.samsthenerd.inline.api.client.renderers.InlineSpriteRenderer;
import com.samsthenerd.inline.api.client.renderers.PlayerHeadRenderer;
import com.samsthenerd.inline.impl.extrahooks.ItemOverlayManager;
import com.samsthenerd.inline.utils.Spritelike;
import com.samsthenerd.inline.utils.SpritelikeRenderers;
import com.samsthenerd.inline.utils.SpritelikeUtils;
import com.samsthenerd.inline.utils.URLSprite;
import com.samsthenerd.inline.xplat.IModMeta;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2568;
import net.minecraft.class_2568.class_5249;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.text.*;

public class InlineClient {
    public static void initClient(){

        // InlineAutoConfig.init();

        addDefaultRenderers();
        addDefaultMatchers();

        addExtraHookTests();
    }

    private static void addDefaultRenderers(){
        InlineClientAPI.INSTANCE.addRenderer(InlineItemRenderer.INSTANCE);
        InlineClientAPI.INSTANCE.addRenderer(InlineEntityRenderer.INSTANCE);
        InlineClientAPI.INSTANCE.addRenderer(InlineSpriteRenderer.INSTANCE);
        InlineClientAPI.INSTANCE.addRenderer(PlayerHeadRenderer.INSTANCE);
    }

    private static void addDefaultMatchers(){
        class_2960 itemMatcherID = new class_2960(Inline.MOD_ID, "item");
        InlineClientAPI.INSTANCE.addMatcher(new RegexMatcher.Standard("item", Standard.IDENTIFIER_REGEX_INSENSITIVE, itemMatcherID,
        (String itemId) ->{
            class_2960 itemActualId = new class_2960(itemId.toLowerCase());
            if(!class_7923.field_41178.method_10250(itemActualId)) return null;
            class_1792 item = class_7923.field_41178.method_10223(itemActualId);
            class_1799 stack = new class_1799(item);
            class_2568 he = new class_2568(class_2568.class_5247.field_24343, new class_5249(stack));
            return new DataMatch(new ItemInlineData(stack), class_2583.field_24360.method_10949(he));
        }, MatcherInfo.fromId(itemMatcherID)));

        class_2960 entityMatcherID = new class_2960(Inline.MOD_ID, "entity");
        InlineClientAPI.INSTANCE.addMatcher(new RegexMatcher.Standard("entity", Standard.IDENTIFIER_REGEX_INSENSITIVE, entityMatcherID,
        (String entityTypeId) ->{
            class_2960 entTypeActualId = new class_2960(entityTypeId.toLowerCase());
            if(!class_7923.field_41177.method_10250(entTypeActualId)) return null;
            class_1299 entType = class_7923.field_41177.method_10223(entTypeActualId);
            EntityInlineData entData = EntityInlineData.fromType(entType);
            return new DataMatch(entData, class_2583.field_24360.method_10949(entData.getEntityDisplayHoverEvent()));
        }, MatcherInfo.fromId(entityMatcherID)));

        /*
        Identifier linkMatcherId = new Identifier(Inline.MOD_ID, "link");
        InlineClientAPI.INSTANCE.addMatcher(new RegexMatcher.Simple("\\[(.*)\\]\\((.*)\\)", linkMatcherId, (MatchResult mr) ->{
            String text = mr.group(1);
            String link = mr.group(2);
            ClickEvent ce = new ClickEvent(ClickEvent.Action.OPEN_URL, link);
            HoverEvent he = new HoverEvent(HoverEvent.Action.SHOW_TEXT, Text.of(link));
            MutableText linkText = Text.literal(text + " 🔗");
            linkText.setStyle(Style.EMPTY.withClickEvent(ce).withHoverEvent(he).withUnderline(true).withColor(Formatting.BLUE));
            return new TextMatch(linkText);
        }, MatcherInfo.fromId(linkMatcherId)));
        */
//
//        Identifier imgMatcherId = new Identifier(Inline.MOD_ID, "imgtest");
//        InlineClientAPI.INSTANCE.addMatcher(new RegexMatcher.Standard("img", "[^\\[\\]]+", imgMatcherId,
//            (String url) -> {
//                var urlId = url.chars()
//                    .mapToObj(ch -> (char)ch)
//                    .filter(c -> c != ':' && Identifier.isCharValid(c))
//                    .collect(StringBuilder::new,StringBuilder::appendCodePoint,StringBuilder::append)
//                    .toString();
//                return new DataMatch(new SpriteInlineData(new URLSprite(url, new Identifier(urlId))));
//            }, MatcherInfo.fromId(imgMatcherId)));

        // InlineClientAPI.INSTANCE.addMatcher(new Identifier(Inline.MOD_ID, "bolditalic"), new RegexMatcher.Simple("(?<ast>\\*{1,3})\\b([^*]+)(\\k<ast>)", (MatchResult mr) ->{
        //     String text = mr.group(2);
        //     int astCount = mr.group(1).length();
        //     MutableText linkText = Text.literal(text);
        //     linkText.setStyle(Style.EMPTY.withBold(astCount >= 2).withItalic(astCount % 2 == 1));
        //     return new TextMatch(linkText);
        // }));

        class_2960 modMatcherId = new class_2960(Inline.MOD_ID, "modicon");
        InlineClientAPI.INSTANCE.addMatcher(new RegexMatcher.Standard("mod", "[0-9A-Za-z._-]+", modMatcherId,
        (String modid) -> {
            String modidLowercase = modid.toLowerCase();
            Optional<IModMeta> maybeMod = IModMeta.getMod(modidLowercase);
            if(maybeMod.isEmpty()){
                return null;
            }
            // IModMeta mod = maybeMod.get();
            return new DataMatch(new ModIconData(modidLowercase), ModIconData.getTooltipStyle(modidLowercase));
        }, MatcherInfo.fromId(modMatcherId)));

        class_2960 faceMatcherId = new class_2960(Inline.MOD_ID, "playerface");
        InlineClientAPI.INSTANCE.addMatcher(new RegexMatcher.Standard("face", "[a-zA-Z0-9_]{1,16}", faceMatcherId, 
        (String playerNameOrUUID) -> {
            GameProfile profile = new GameProfile(null, playerNameOrUUID);
            PlayerHeadData headData = new PlayerHeadData(profile);
            return new DataMatch(headData, class_2583.field_24360.method_10949(headData.getEntityDisplayHoverEvent()));
        }, MatcherInfo.fromId(faceMatcherId)));
    }

    private static void addExtraHookTests(){
        // these shouldn't be in the mod probably :p but this is how to use them.
//        ItemOverlayManager.addRenderer(Items.COOKIE, new ItemOverlayRenderer() {
//            @Override
//            public void render(ItemStack stack, DrawContext drawContext) {
//                Spritelike cookiemonster = new URLSprite("https://easydrawingguides.com/wp-content/uploads/2019/01/Cookie-Monster-10.png",
//                    Identifier.of("cookiemonster", "cookiermonster"));
//                SpritelikeRenderers.getRenderer(cookiemonster).drawSprite(cookiemonster, drawContext, 0, 6, 100, 10, 10);
//            }
//        });
//        ItemOverlayManager.addRenderer(Items.CHEST, new ItemOverlayRenderer() {
//            @Override
//            public void render(ItemStack stack, DrawContext drawContext) {
//                Spritelike cookiemonster = new URLSprite("https://easydrawingguides.com/wp-content/uploads/2019/01/Cookie-Monster-10.png",
//                    Identifier.of("cookiemonster", "cookiermonster"));
//                SpritelikeRenderers.getRenderer(cookiemonster).drawSprite(cookiemonster, drawContext, 0, 6, 100, 10, 10);
//            }
//        });
////
//        ItemOverlayManager.addRenderer(Items.POTION, new ItemOverlayRenderer() {
//            @Override
//            public void render(ItemStack stack, DrawContext drawContext) {
//
//                var effects = PotionUtil.getPotionEffects(stack);
//                if(effects.isEmpty()) return;
//                var effect = effects.get(0);
//                var effectSprite = MinecraftClient.getInstance().getStatusEffectSpriteManager().getSprite(effect.getEffectType());
//                Spritelike effectSpritelike = SpritelikeUtils.spritelikeFromSprite(effectSprite);
//
//                SpritelikeRenderers.getRenderer(effectSpritelike).drawSprite(effectSpritelike, drawContext, 7, 7, 100, 9, 9);
//            }
//        });
    }
}
