package com.samsthenerd.inline.utils;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.mixin.feature.playerskins.MixinAccessPlayerModelParts;
import com.samsthenerd.inline.mixin.feature.playerskins.MixinClientAccessor;
import com.samsthenerd.inline.mixin.feature.playerskins.MixinClientHeadChecker;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2631;
import net.minecraft.class_310;
import net.minecraft.class_3312;
import net.minecraft.class_3545;
import net.minecraft.class_745;
import net.minecraft.class_7497;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;

public class FakeClientPlayerMaker {
    public static class_3545<class_1297, Boolean> getPlayerEntity(GameProfile profile){
        GameProfile betterProfile = getBetterProfile(profile);
        boolean isActuallyBetter = false;
        GameProfile profileToUse = profile;
        if(betterProfile != null){
            profileToUse = betterProfile;
            isActuallyBetter = true;
        }
        class_1657 player = new class_745(class_310.method_1551().field_1687, profileToUse){
            @Override
            public boolean method_5733() {
                return false;
            }
        };
        player.field_7502 = player.field_7521 = (player.method_23318() - 0.5);
        player.field_7524 = player.field_7500 = player.method_23317();
        player.field_7522 = player.field_7499 = player.method_23321();
        player.method_5841().method_12778(MixinAccessPlayerModelParts.getPlayerModelParts(), (byte)0b11111111);
        return new class_3545<>(
            player,
            isActuallyBetter
        );
    }

    private static final Map<UUID, Optional<GameProfile>> UUID_PROFILE_CACHE = new HashMap<>();
    private static final Map<String, Optional<GameProfile>> NAME_PROFILE_CACHE = new HashMap<>();

    private static class_7497 apiServices;
    private static MinecraftSessionService sessionService;
    private static class_3312 userCache;
    private static Executor executor;

    static {
        class_310 client = class_310.method_1551();
        apiServices = class_7497.method_44143(((MixinClientAccessor)client).getAuthenticationService(), client.field_1697);
        sessionService = apiServices.comp_837();
        apiServices.comp_840().method_37157(client);
        userCache = apiServices.comp_840();
        executor = client;
    }

    @Nullable
    public static GameProfile getBetterProfile(GameProfile weakProf){
        // try to find the better profile in our caches
        if(weakProf.getId() != null){
            Optional<GameProfile> maybeProf = UUID_PROFILE_CACHE.get(weakProf.getId());
            if(maybeProf != null){
                return maybeProf.orElse(null);
            }
        }
        if(weakProf.getName() != null && !weakProf.getName().equals("")){
            Optional<GameProfile> maybeProf = NAME_PROFILE_CACHE.get(weakProf.getName().toLowerCase());
            if(maybeProf != null){
                return maybeProf.orElse(null);
            }
        }
        // can't find, try to fetch it

        // set these to empty optionals so we don't repeatedly fetch a ton
        if(weakProf.getId() != null)
            UUID_PROFILE_CACHE.put(weakProf.getId(), Optional.empty());
        if(weakProf.getName() != null && !weakProf.getName().equals(""))
            NAME_PROFILE_CACHE.put(weakProf.getName().toLowerCase(), Optional.empty());


        if(MixinClientHeadChecker.getSessionService() == null){
            class_2631.method_39765(apiServices, executor);
        }
        class_3312.method_14510(true);
        class_2631.method_11335(weakProf, FakeClientPlayerMaker::acceptBetterProf);

        return null;
    }

    private static void acceptBetterProf(GameProfile betterProf){
        if(!betterProf.isComplete()){
            // I can't consistently reproduce this issue to debug it, let's just log it and call it a day.
            Inline.LOGGER.warn(
                    "Could not complete profile, either username does not belong to a player or some other error occured (can try restarting the game and clearing usercache.json). Incomplete Profile: "
                    + betterProf
            );
        }
        if(betterProf.getId() != null){
            UUID_PROFILE_CACHE.put(betterProf.getId(), Optional.of(betterProf));
        }
        if(betterProf.getName() != null && !betterProf.getName().equals("")){
            NAME_PROFILE_CACHE.put(betterProf.getName().toLowerCase(), Optional.of(betterProf));
        }
    }
}
