package com.samsthenerd.inline.mixin.core;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.impl.InlineStyle;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5251;
import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@Mixin(class_2583.class)
public class MixinInlineStyle implements InlineStyle {

    @Unique
    private final Map<ISComponent<?>, Object> components = new HashMap<>();

    @Unique
    private class_2583 getCopy(){
        return InlineStyle.makeCopy((class_2583)(Object)this);
    }

    @Override
    public class_2583 withInlineData(InlineData data){
        return getCopy().setComponent(InlineStyle.INLINE_DATA_COMP, data);
    }

    @SuppressWarnings("unchecked")
    @Override
    public <C> C getComponent(ISComponent<C> component){
        return (C)components.getOrDefault(component, component.defaultValue());
    }

    @Override
    public Set<ISComponent<?>> getComponents(){
        return new HashSet<>(components.keySet());
    }

    @Override
    public <C> class_2583 withComponent(ISComponent<C> component, @Nullable C value){
        return getCopy().setComponent(component, value);
    }

    @Override
    public <C> class_2583 setComponent(ISComponent<C> component, @Nullable C value){
        if(value == null){
            this.components.remove(component);
        } else {
            this.components.put(component, value);
        }
        return (class_2583)(Object)this;
    }

    @SuppressWarnings("unchecked")
    @ModifyReturnValue(method = "withParent(Lnet/minecraft/text/Style;)Lnet/minecraft/text/Style;", at = @At("RETURN"))
	private class_2583 InlineStyWithParent(class_2583 original, class_2583 parent) {
        class_2583 maybeNewStyle = InlineStyle.makeCopy(original);
        keepData(maybeNewStyle); // make sure that we've still got everything.
        for(ISComponent comp : parent.getComponents()){
            if(!maybeNewStyle.getComponents().contains(comp)){
                maybeNewStyle.setComponent(comp, parent.getComponent(comp));
            } else {
                maybeNewStyle.setComponent(comp, comp.merger().apply(getComponent(comp), parent.getComponent(comp)));
            }
        }
        return maybeNewStyle;
	}

	@ModifyReturnValue(method = "equals(Ljava/lang/Object;)Z", at = @At("RETURN"))
	private boolean InlineStyEquals(boolean original, Object obj) {
		if (original && this != obj && (obj instanceof InlineStyle style)) {
            Set<ISComponent> allComps = Stream.concat(
                    this.components.keySet().stream(),
                    style.getComponents().stream()
            ).collect(Collectors.toSet());
            // see if any comps are different
            for(ISComponent<?> comp : allComps){
                if(!Objects.equals(this.getComponent(comp), style.getComponent(comp))){
                    return false;
                }
            }
		}
        return original;
	}

    // a fix from skye to prevent breaking with font mods like caxton.
    @ModifyReturnValue(method = "getFont", at = @At("RETURN"))
    private class_2960 overrideFont(class_2960 original) {
        if(this.getInlineData() != null){
            return new class_2960("inline", "dummy_font");
        }
        return original;
    }

    @Unique
    private class_2583 keepData(class_2583 newStyle){
        for(ISComponent comp : components.keySet()){
            newStyle.setComponent(comp, getComponent(comp));
        }
        return newStyle;
    }

    @ModifyReturnValue(method = "withColor(Lnet/minecraft/text/TextColor;)Lnet/minecraft/text/Style;",
    at=@At("RETURN"))
    private class_2583 fixWithColor(class_2583 newStyle, class_5251 color){
        return keepData(newStyle);
    }

    @ModifyReturnValue(method = "withBold(Ljava/lang/Boolean;)Lnet/minecraft/text/Style;",
    at=@At("RETURN"))
    private class_2583 fixWithBold(class_2583 newStyle, Boolean boldBool){
        return keepData(newStyle);
    }
    
    @ModifyReturnValue(method = "withItalic(Ljava/lang/Boolean;)Lnet/minecraft/text/Style;",
    at=@At("RETURN"))
	private class_2583 fixWithItalic(class_2583 newStyle, Boolean boldBool){
		return keepData(newStyle);
	}

    @ModifyReturnValue(method = "withUnderline(Ljava/lang/Boolean;)Lnet/minecraft/text/Style;",
    at=@At("RETURN"))
	private class_2583 fixWithUnderline(class_2583 newStyle, Boolean boldBool){
		return keepData(newStyle);
	}

    @ModifyReturnValue(method = "withStrikethrough(Ljava/lang/Boolean;)Lnet/minecraft/text/Style;",
    at=@At("RETURN"))
	private class_2583 fixWithStrikethrough(class_2583 newStyle, Boolean boldBool){
		return keepData(newStyle);
	}

    @ModifyReturnValue(method = "withObfuscated(Ljava/lang/Boolean;)Lnet/minecraft/text/Style;",
    at=@At("RETURN"))
	private class_2583 fixWithObfuscated(class_2583 newStyle, Boolean boldBool){
		return keepData(newStyle);
	}

    @ModifyReturnValue(method = "withClickEvent(Lnet/minecraft/text/ClickEvent;)Lnet/minecraft/text/Style;",
    at=@At("RETURN"))
	private class_2583 fixWithClickEvent(class_2583 newStyle, class_2558 clickEvent){
		return keepData(newStyle);
	}

    @ModifyReturnValue(method = "withHoverEvent(Lnet/minecraft/text/HoverEvent;)Lnet/minecraft/text/Style;",
    at=@At("RETURN"))
	private class_2583 fixWithHoverEvent(class_2583 newStyle, class_2568 hoverEvent){
		return keepData(newStyle);
	}

    @ModifyReturnValue(method = "withInsertion(Ljava/lang/String;)Lnet/minecraft/text/Style;",
    at=@At("RETURN"))
	private class_2583 fixWithInsertion(class_2583 newStyle, String insertionString){
		return keepData(newStyle);
	}

    @ModifyReturnValue(method = "withFont(Lnet/minecraft/util/Identifier;)Lnet/minecraft/text/Style;",
    at=@At("RETURN"))
	private class_2583 fixWithFont(class_2583 newStyle, class_2960 fontID){
		return keepData(newStyle);
	}

    @ModifyReturnValue(method = "withFormatting(Lnet/minecraft/util/Formatting;)Lnet/minecraft/text/Style;",
    at=@At("RETURN"))
	private class_2583 fixWithFormatting(class_2583 newStyle, class_124 formatting){
		return keepData(newStyle);
	}

    @ModifyReturnValue(method = "withExclusiveFormatting(Lnet/minecraft/util/Formatting;)Lnet/minecraft/text/Style;",
    at=@At("RETURN"))
	private class_2583 fixWithExclusiveFormatting(class_2583 newStyle, class_124 formatting){
		return keepData(newStyle);
	}
}

