package com.samsthenerd.inline.api.matching;

import net.minecraft.class_2561;
import net.minecraft.class_2960;

/**
 * User-facing information about a matcher. For most cases you can just use
 * {@link MatcherInfo#fromId(id)} and add the translations in your lang files.
 */
public class MatcherInfo {
    private final class_2561 rawTitle;
    private final class_2561 styledTitle;
    private final class_2561 example;
    private final class_2561 description;

    public MatcherInfo(class_2561 rawTitle, class_2561 styledTitle, class_2561 example, class_2561 description){
        this.rawTitle = rawTitle;
        this.styledTitle = styledTitle;
        this.example = example;
        this.description = description;
    }

    public static MatcherInfo fromId(class_2960 id){
        return new MatcherInfo(
            class_2561.method_43471("matcher." + id.method_12836() + "." + id.method_12832() + ".title"),
            class_2561.method_43471("matcher." + id.method_12836() + "." + id.method_12832() + ".title.styled"),
            class_2561.method_43471("matcher." + id.method_12836() + "." + id.method_12832() + ".example"),
            class_2561.method_43471("matcher." + id.method_12836() + "." + id.method_12832() + ".description")
        );
    }

    public class_2561 getTitle(boolean styled){
        if(styled){
            return styledTitle;
        }
        return rawTitle;
    }

    public class_2561 getExample(){
        return example;
    }

    public class_2561 getDescription(){
        return description;
    }
}
