/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.utils.cradles;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.samsthenerd.inline.utils.EntityCradle;
import com.samsthenerd.inline.utils.FakeClientPlayerMaker;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_4844;

public class PlayerCradle
extends EntityCradle {
    private static final HashMap<UUID, class_1297> UUID_PLAYER_CACHE = new HashMap();
    private static final HashMap<String, class_1297> NAME_PLAYER_CACHE = new HashMap();
    public static final Codec<GameProfile> GAME_PROFILE_CODEC = Codec.either((Codec)Codec.STRING.fieldOf("username").codec(), (Codec)class_4844.field_40825.fieldOf("uuid").codec()).xmap(nameOrId -> (GameProfile)nameOrId.map(name -> new GameProfile(null, name), uuid -> new GameProfile(uuid, null)), profile -> {
        String name = profile.getName();
        if (name != null && !name.isEmpty()) {
            return Either.left((Object)name);
        }
        return Either.right((Object)profile.getId());
    });
    private GameProfile profile;

    public PlayerCradle(GameProfile profile) {
        this.profile = profile;
    }

    public GameProfile getProfile() {
        return this.profile;
    }

    @Override
    public EntityCradle.CradleType<?> getType() {
        return PlayerCradleType.INSTANCE;
    }

    @Override
    public String getId() {
        return this.profile.getId() == null ? this.profile.getName() : this.profile.getId().toString();
    }

    @Override
    public class_1297 getEntity(class_1937 world) {
        UUID playerId = this.profile.getId();
        if (playerId != null && UUID_PLAYER_CACHE.containsKey(playerId)) {
            return UUID_PLAYER_CACHE.get(playerId);
        }
        String playerName = this.profile.getName();
        if (playerName != null && !playerName.equals("") && NAME_PLAYER_CACHE.containsKey(playerName)) {
            return NAME_PLAYER_CACHE.get(playerName);
        }
        if (!world.method_8608()) {
            return null;
        }
        class_3545<class_1297, Boolean> playerRes = FakeClientPlayerMaker.getPlayerEntity(this.profile);
        if (((Boolean)playerRes.method_15441()).booleanValue() && playerId != null) {
            UUID_PLAYER_CACHE.put(playerId, (class_1297)playerRes.method_15442());
        }
        if (((Boolean)playerRes.method_15441()).booleanValue() && playerName != null && !playerName.equals("")) {
            NAME_PLAYER_CACHE.put(playerName, (class_1297)playerRes.method_15442());
        }
        return (class_1297)playerRes.method_15442();
    }

    private static class PlayerCradleType
    implements EntityCradle.CradleType<PlayerCradle> {
        public static PlayerCradleType INSTANCE = EntityCradle.addCradleType(new PlayerCradleType());

        private PlayerCradleType() {
        }

        @Override
        public class_2960 getId() {
            return new class_2960("inline", "nbt");
        }

        @Override
        public Codec<PlayerCradle> getCodec() {
            return GAME_PROFILE_CODEC.xmap(PlayerCradle::new, PlayerCradle::getProfile);
        }
    }
}

