package com.samsthenerd.inline.api.matching;

import java.util.ArrayList;
import java.util.List;
import java.util.Map.Entry;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3545;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.api.matching.InlineMatch.DataMatch;
import com.samsthenerd.inline.api.matching.InlineMatch.TextMatch;

public interface ContinuousMatcher extends InlineMatcher{

    ContinuousMatchResult match(String input, MatchContext matchContext);

    default void match(MatchContext matchContext){
        for(Entry<Integer, String> seqEntry : matchContext.getUnmatchedSequences().entrySet()){
            ContinuousMatchResult res = match(seqEntry.getValue(), matchContext);
            for(class_3545<class_3545<Integer, Integer>, InlineMatch> match : res.getMatches()){
                int matchStart = match.method_15442().method_15442() + seqEntry.getKey();
                int matchEnd = match.method_15442().method_15441() + seqEntry.getKey();
                matchContext.addMatch(matchStart, matchEnd, match.method_15441());
            }
        }
    }

    class ContinuousMatchResult {
        
        // Horrible generic, but whatever, consider it an implementation detail
        private List<class_3545<class_3545<Integer, Integer>, InlineMatch>> matches = new ArrayList<>();

        public ContinuousMatchResult addMatch(int start, int end, InlineData data){
            return addMatch(start, end, data, class_2583.field_24360);
        }
        
        public ContinuousMatchResult addMatch(int start, int end, class_2561 text){
            return addMatch(start, end, new TextMatch(text));
        }

        public ContinuousMatchResult addMatch(int start, int end, InlineData data, class_2583 style){
            return addMatch(start, end, new DataMatch(data, style));
        }

        public ContinuousMatchResult addMatch(int start, int end, InlineMatch match){
            // TODO: add conflict detection here ?
            matches.add(new class_3545<>(new class_3545<>(start, end), match));
            return this;
        }

        public List<class_3545<class_3545<Integer, Integer>, InlineMatch>> getMatches(){
            return new ArrayList<>(matches);
        }    
    }
}
