/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline;

import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.client.InlineClientAPI;
import com.samsthenerd.inline.api.client.renderers.InlineEntityRenderer;
import com.samsthenerd.inline.api.client.renderers.InlineItemRenderer;
import com.samsthenerd.inline.api.client.renderers.InlineSpriteRenderer;
import com.samsthenerd.inline.api.client.renderers.PlayerHeadRenderer;
import com.samsthenerd.inline.api.data.EntityInlineData;
import com.samsthenerd.inline.api.data.ItemInlineData;
import com.samsthenerd.inline.api.data.ModIconData;
import com.samsthenerd.inline.api.data.PlayerHeadData;
import com.samsthenerd.inline.api.data.SpriteInlineData;
import com.samsthenerd.inline.api.matching.InlineMatch;
import com.samsthenerd.inline.api.matching.MatcherInfo;
import com.samsthenerd.inline.api.matching.RegexMatcher;
import com.samsthenerd.inline.impl.ProfileComponentUtil;
import com.samsthenerd.inline.utils.URLSprite;
import com.samsthenerd.inline.xplat.IModMeta;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9296;

public class InlineClient {
    public static void initClient() {
        InlineClient.addDefaultRenderers();
        InlineClient.addDefaultMatchers();
        InlineClient.addExtraHookTests();
    }

    private static void addDefaultRenderers() {
        InlineClientAPI.INSTANCE.addRenderer(InlineItemRenderer.INSTANCE);
        InlineClientAPI.INSTANCE.addRenderer(InlineEntityRenderer.INSTANCE);
        InlineClientAPI.INSTANCE.addRenderer(InlineSpriteRenderer.INSTANCE);
        InlineClientAPI.INSTANCE.addRenderer(PlayerHeadRenderer.INSTANCE);
    }

    private static void addDefaultMatchers() {
        class_2960 itemMatcherID = Inline.id("item");
        InlineClientAPI.INSTANCE.addMatcher(new RegexMatcher.Standard("item", RegexMatcher.Standard.IDENTIFIER_REGEX_INSENSITIVE, itemMatcherID, itemId -> {
            class_2960 itemActualId = class_2960.method_60654((String)itemId.toLowerCase());
            if (!class_7923.field_41178.method_10250(itemActualId)) {
                return null;
            }
            class_1792 item = (class_1792)class_7923.field_41178.method_10223(itemActualId);
            class_1799 stack = new class_1799((class_1935)item);
            class_2568 he = new class_2568(class_2568.class_5247.field_24343, (Object)new class_2568.class_5249(stack));
            return new InlineMatch.DataMatch(new ItemInlineData(stack), class_2583.field_24360.method_10949(he));
        }, MatcherInfo.fromId(itemMatcherID)));
        class_2960 entityMatcherID = Inline.id("entity");
        InlineClientAPI.INSTANCE.addMatcher(new RegexMatcher.Standard("entity", RegexMatcher.Standard.IDENTIFIER_REGEX_INSENSITIVE, entityMatcherID, entityTypeId -> {
            class_2960 entTypeActualId = class_2960.method_60654((String)entityTypeId.toLowerCase());
            if (!class_7923.field_41177.method_10250(entTypeActualId)) {
                return null;
            }
            class_1299 entType = (class_1299)class_7923.field_41177.method_10223(entTypeActualId);
            EntityInlineData entData = EntityInlineData.fromType(entType);
            return new InlineMatch.DataMatch(entData, class_2583.field_24360.method_10949(entData.getEntityDisplayHoverEvent()));
        }, MatcherInfo.fromId(entityMatcherID)));
        class_2960 imgMatcherId = Inline.id("imgtest");
        InlineClientAPI.INSTANCE.addMatcher(new RegexMatcher.Standard("img", "[^\\[\\]]+", imgMatcherId, url -> {
            String urlId = url.chars().mapToObj(ch -> Character.valueOf((char)ch)).filter(c -> c.charValue() != ':' && class_2960.method_12831((char)c.charValue())).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
            return new InlineMatch.DataMatch(new SpriteInlineData(new URLSprite((String)url, class_2960.method_60654((String)urlId))));
        }, MatcherInfo.fromId(imgMatcherId)));
        class_2960 modMatcherId = Inline.id("modicon");
        InlineClientAPI.INSTANCE.addMatcher(new RegexMatcher.Standard("mod", "[0-9A-Za-z._-]+", modMatcherId, modid -> {
            String modidLowercase = modid.toLowerCase();
            Optional<IModMeta> maybeMod = IModMeta.getMod(modidLowercase);
            if (maybeMod.isEmpty()) {
                return null;
            }
            return new InlineMatch.DataMatch(new ModIconData(modidLowercase), ModIconData.getTooltipStyle(modidLowercase));
        }, MatcherInfo.fromId(modMatcherId)));
        class_2960 faceMatcherId = Inline.id("playerface");
        InlineClientAPI.INSTANCE.addMatcher(new RegexMatcher.Standard("face", "[a-zA-Z0-9_]{1,16}|[a-f0-9]{8}(?:-[a-f0-9]{4}){4}[a-f0-9]{8}", faceMatcherId, playerNameOrUUID -> {
            class_9296 profile = playerNameOrUUID.length() > 16 ? ProfileComponentUtil.from(UUID.fromString(playerNameOrUUID), null) : ProfileComponentUtil.from(null, playerNameOrUUID);
            PlayerHeadData headData = new PlayerHeadData(profile);
            return new InlineMatch.DataMatch(headData, class_2583.field_24360.method_10949(headData.getEntityDisplayHoverEvent()));
        }, MatcherInfo.fromId(faceMatcherId)));
    }

    private static void addExtraHookTests() {
    }
}

