package com.samsthenerd.inline.utils.cradles;

import com.mojang.serialization.Codec;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.utils.EntityCradle;
import java.util.HashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

/**
 * An entity cradle backed by the entity's full nbt data
 */
public class NbtCradle extends EntityCradle {

    private static final HashMap<class_2487, class_1297> ENTITY_CACHE = new HashMap<>();

    private class_1297 ownCachedEntity; // to avoid having to hash the nbt compound every time
    private class_2487 entityTag;

    public NbtCradle(class_1297 entity){
        entityTag = new class_2487();
        entity.method_5662(entityTag);
        ownCachedEntity = entity;
        ENTITY_CACHE.put(entityTag, entity);
    }

    public NbtCradle(class_2487 tag){
        entityTag = tag;
    }

    public class_2487 getTag(){
        return entityTag;
    }

    public CradleType<?> getType(){
        return NbtCradleType.INSTANCE;
    }

    public class_1297 getEntity(class_1937 world){
        if(ownCachedEntity != null){
            return ownCachedEntity;
        }
        if(ENTITY_CACHE.containsKey(entityTag)){
            ownCachedEntity = ENTITY_CACHE.get(entityTag);
            return ownCachedEntity;
        }

        ownCachedEntity = class_1299.method_5892(entityTag, world).orElse(null);
        ENTITY_CACHE.put(entityTag, ownCachedEntity);
        return ownCachedEntity;
    }

    private static class NbtCradleType implements CradleType<NbtCradle>{

        public static NbtCradleType INSTANCE = EntityCradle.addCradleType(new NbtCradleType());

        public class_2960 getId(){
            return Inline.id( "nbt");
        }

        public Codec<NbtCradle> getCodec(){
            return class_2487.field_25128.xmap(NbtCradle::new, NbtCradle::getTag);
        }
    }
}
