package com.samsthenerd.inline.config;

import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.client.InlineClientAPI;
import com.samsthenerd.inline.api.matching.InlineMatcher;
import com.samsthenerd.inline.api.matching.MatcherInfo;

import com.samsthenerd.inline.xplat.IModMeta;
import com.samsthenerd.inline.xplat.IXPlatAbstractions;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.DoubleListEntry;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_437;

/*
 * Should only run on client
 */
public class InlineConfigHandler {
    public static class_437 getConfigScreen(class_437 parent){
        // return AutoConfig.getConfigScreen(InlineAutoConfig.class, parent).get();

        InlineClientConfigImpl.getInstance().reloadFromFile(); // make sure we're up to date

        ConfigBuilder builder = ConfigBuilder.create()
            .setParentScreen(parent)
            .setTitle(class_2561.method_43471("config.inline.title"));
        
        ConfigCategory matcherConfig = builder.getOrCreateCategory(class_2561.method_43471("config.inline.category.matchers"));

        ConfigEntryBuilder entryBuilder = builder.entryBuilder();

        for(InlineMatcher matcher : InlineClientAPI.INSTANCE.getAllMatchers()){
            matcherConfig.addEntry(makeMatcherConfig(entryBuilder, matcher));
        }

        ConfigCategory extraFeatures = builder.getOrCreateCategory(class_2561.method_43471("config.inline.category.extras"));

        BooleanListEntry modIconEntry = entryBuilder.startBooleanToggle(class_2561.method_43471("config.inline.extras.modicon"), 
            InlineClientConfigImpl.getInstance().shouldRenderModIcons())
            .setTooltip(class_2561.method_43471("config.inline.extras.modicon.desc"))
            .setDefaultValue(true)
            .setYesNoTextSupplier((boolval) -> boolval ? 
                class_2561.method_43471("addServer.resourcePack.enabled").method_10862(class_2583.field_24360.method_10977(class_124.field_1060)) : 
                class_2561.method_43471("addServer.resourcePack.disabled").method_10862(class_2583.field_24360.method_10977(class_124.field_1061))
            )
            .setSaveConsumer((enabled) -> InlineClientConfigImpl.getInstance().setShouldRenderModIcons(enabled))
            .build();

        extraFeatures.addEntry(modIconEntry);

        DoubleListEntry chatCapField = entryBuilder.startDoubleField(class_2561.method_43471("config.inline.extras.chatcap"),
                InlineClientConfigImpl.getInstance().maxChatSizeModifier())
                .setTooltip(class_2561.method_43471("config.inline.extras.chatcap.desc"))
                .setDefaultValue(1.5).setMin(1.0).setMax(2.0)
                .setSaveConsumer((newCap) -> InlineClientConfigImpl.getInstance().setChatScaleCap(newCap))
                .build();
        extraFeatures.addEntry(chatCapField);

        if(IModMeta.getMod("create").isPresent()){
            BooleanListEntry createToggleEntry = entryBuilder.startBooleanToggle(class_2561.method_43471("config.inline.extras.createinterop"),
                            InlineClientConfigImpl.getInstance().shouldDoCreateMixins())
                    .setTooltip(class_2561.method_43471("config.inline.extras.createinterop.desc"))
                    .setDefaultValue(true)
                    .setYesNoTextSupplier((boolval) -> boolval ?
                            class_2561.method_43471("addServer.resourcePack.enabled").method_10862(class_2583.field_24360.method_10977(class_124.field_1060)) :
                            class_2561.method_43471("addServer.resourcePack.disabled").method_10862(class_2583.field_24360.method_10977(class_124.field_1061))
                    )
                    .setSaveConsumer((enabled) -> InlineClientConfigImpl.getInstance().setShouldDoCreateMixins(enabled))
                    .build();
            extraFeatures.addEntry(createToggleEntry);
        }

        builder.setSavingRunnable(() -> InlineClientConfigImpl.getInstance().save());

        return builder.build();
    }

    private static AbstractConfigListEntry makeMatcherConfig(ConfigEntryBuilder entryBuilder, InlineMatcher matcher){
        MatcherInfo info = matcher.getInfo();
        // SubCategoryBuilder subBuilder = entryBuilder.startSubCategory(info.getTitle()).setExpanded(true);

        boolean matcherEnabled = InlineClientConfigImpl.getInstance().isMatcherEnabled(matcher.getId());
        return entryBuilder.startBooleanToggle(info.getTitle(matcherEnabled), matcherEnabled)
            .setTooltip(info.getDescription())
            .setDefaultValue(true)
            .setYesNoTextSupplier((boolval) -> boolval ? 
                class_2561.method_43471("addServer.resourcePack.enabled").method_10862(class_2583.field_24360.method_10977(class_124.field_1060)) : 
                class_2561.method_43471("addServer.resourcePack.disabled").method_10862(class_2583.field_24360.method_10977(class_124.field_1061))
            )
            .setSaveConsumer((enabled) -> InlineClientConfigImpl.getInstance().someableMatcher(matcher.getId(), enabled))
            .build();

    }
}
