package com.samsthenerd.inline.utils;


import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.NotNull;

import javax.annotation.Nullable;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;

// this sprite can be used to fetch pngs or gifs from URLs, local or remote.
public class URLSprite extends Spritelike{
    
    private final String url;
    private final class_2960 id;

    @NotNull
    private final UnaryOperator<SpriteUVLens> lensModifier;

    @Nullable
    private IntPair textDims;
    @Nullable
    private SpriteUVLens lens;
    @Nullable
    private class_2960 textureID;

//    public static final SpritePosDataOld DEFAULT_UNLOADED_POS_DATA = new SpritePosDataOld(0,0,1,1,0,0);

    public URLSprite(String url, class_2960 id){
        this(url, id, UnaryOperator.identity());
    }

    public URLSprite(String url, class_2960 id, UnaryOperator<SpriteUVLens> lensModifier){
        this.url = url;
        this.id = id;
        this.lensModifier = lensModifier;
    }

    public SpritelikeType getType(){
        return UrlSpriteType.INSTANCE;
    }

    public class_2960 getTextureId(){
        return URLTextureUtils.loadTextureFromURL(url, id);
    }

    public class_2960 getId(){
        return id;
    }

    public String getUrl(){
        return url;
    }

    private IntPair getOrFetchDims(){
        if(this.textDims != null) return this.textDims;
        var newTextInfo = URLTextureUtils.getTextureInfo(id);
        if(newTextInfo != null){
            this.textDims = newTextInfo.method_15442();
        }
        return textDims;
    }

    private SpriteUVLens getOrFetchLens(){
        if(this.lens != null) return this.lens;
        var newTextInfo = URLTextureUtils.getTextureInfo(id);
        if(newTextInfo != null){
            this.lens = lensModifier.apply(newTextInfo.method_15441());
        }
        return this.lens;
    }

    @Override
    public int getTextureWidth(){
        return Objects.requireNonNullElse(getOrFetchDims(), new IntPair(0, 0)).width();
    }

    @Override
    public int getTextureHeight(){
        return Objects.requireNonNullElse(getOrFetchDims(), new IntPair(0, 0)).height();
    }

    @Override
    public SpriteUVRegion getUVs(long time) {
        return Objects.requireNonNullElse(getOrFetchLens(), SpriteUVLens::identity).genUVs(time);
    }

    public static class UrlSpriteType implements SpritelikeType{
        public static final UrlSpriteType INSTANCE = new UrlSpriteType();
        private static final MapCodec<URLSprite> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            Codec.STRING.fieldOf("url").forGetter(URLSprite::getUrl),
            class_2960.field_25139.fieldOf("id").forGetter(URLSprite::getId)
        ).apply(instance, URLSprite::new));

        public MapCodec<URLSprite> getCodec(){
            return CODEC;
        }

        public String getId(){
            return "url";
        }
    }
}
