package com.samsthenerd.inline.api.client.renderers;

import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.client.GlowHandling;
import com.samsthenerd.inline.api.client.InlineRenderer;
import com.samsthenerd.inline.api.data.PlayerHeadData;
import com.samsthenerd.inline.api.data.SpriteInlineData;
import com.samsthenerd.inline.utils.TextureSprite;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_1071;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class PlayerHeadRenderer implements InlineRenderer<PlayerHeadData>{

    public static final PlayerHeadRenderer INSTANCE = new PlayerHeadRenderer();

    @Override
    public class_2960 getId(){
        return Inline.id( "playerhead");
    }

    public class_2960 textureFromHeadData(PlayerHeadData data){
        class_1071 playerSkinProvider = class_310.method_1551().method_1582();
        return playerSkinProvider.method_52862(data.profile().comp_2413()).comp_1626();
    }

    public SpriteInlineData getFace(PlayerHeadData data){
        TextureSprite faceSprite = TextureSprite.fromPixels(textureFromHeadData(data),
            8, 8, 8, 8, 64, 64);
        return new SpriteInlineData(faceSprite);
    }

    public SpriteInlineData getOuter(PlayerHeadData data){
        TextureSprite faceSprite = TextureSprite.fromPixels(textureFromHeadData(data),
            40, 8, 8, 8, 64, 64);
        return new SpriteInlineData(faceSprite);
    }

    @Override
    public int render(PlayerHeadData data, class_332 context, int index, class_2583 style, int codepoint, TextRenderingContext trContext){
        SpriteInlineData faceSpriteData = getFace(data);
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_22904(0.25, 0.25, 0);
        matrices.method_22905(8/(float)8.5, 8/(float)8.5,1);
        InlineSpriteRenderer.INSTANCE.render(faceSpriteData, context, index, style, codepoint, trContext);
        matrices.method_22909();
        SpriteInlineData outerSpriteData = getOuter(data);
        matrices.method_22903();
        matrices.method_46416(0, 0, 10);
        int res = InlineSpriteRenderer.INSTANCE.render(outerSpriteData, context, index, style, codepoint, trContext);
        matrices.method_22909();
        return res;
    }

    @Override
    public int charWidth(PlayerHeadData data, class_2583 style, int codepoint){
        return 8;
    }

    @Override
    public GlowHandling getGlowPreference(PlayerHeadData forData){
        return new GlowHandling.Full(forData.profile().comp_2411().map(Objects::toString).orElseGet(() -> forData.profile().comp_2410().get()).toLowerCase());
    }
}
