/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.utils;

import com.mojang.blaze3d.platform.TextureUtil;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.mixin.core.NativeImageAccessor;
import com.samsthenerd.inline.utils.IntPair;
import com.samsthenerd.inline.utils.SpriteUVLens;
import com.samsthenerd.inline.utils.SpriteUVRegion;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import org.lwjgl.PointerBuffer;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class URLTextureUtils {
    private static final Map<class_2960, class_2960> LOADED_TEXTURES = Collections.synchronizedMap(new HashMap());
    private static final Map<class_2960, class_3545<IntPair, SpriteUVLens>> TEXTURE_INFO = Collections.synchronizedMap(new HashMap());
    private static final Set<class_2960> IN_PROGRESS_TEXTURES = Collections.synchronizedSet(new HashSet());

    @Nullable
    public static class_2960 loadTextureFromURL(String url, class_2960 textureId) {
        class_2960 maybeTexture = LOADED_TEXTURES.get(textureId);
        if (maybeTexture != null) {
            return maybeTexture;
        }
        if (IN_PROGRESS_TEXTURES.contains(textureId)) {
            return null;
        }
        IN_PROGRESS_TEXTURES.add(textureId);
        CompletableFuture.runAsync(() -> {
            try {
                URL textureUrl = new URL(url);
                URLConnection conn = textureUrl.openConnection();
                String contentType = conn.getContentType();
                if ("image/png".equals(contentType)) {
                    InputStream stream = conn.getInputStream();
                    class_1011 baseImage = class_1011.method_4309((InputStream)stream);
                    class_310.method_1551().execute(() -> {
                        class_1043 texture = new class_1043(baseImage);
                        class_310.method_1551().method_1531().method_4616(textureId, (class_1044)texture);
                        LOADED_TEXTURES.put(textureId, textureId);
                        TEXTURE_INFO.put(textureId, (class_3545<IntPair, SpriteUVLens>)new class_3545((Object)new IntPair(baseImage.method_4307(), baseImage.method_4323()), (Object)SpriteUVRegion.FULL.asLens()));
                        IN_PROGRESS_TEXTURES.remove(textureId);
                    });
                } else if ("image/gif".equals(contentType)) {
                    ByteBuffer byBuf = TextureUtil.readResource((InputStream)conn.getInputStream());
                    byBuf.rewind();
                    URLTextureUtils.readGif(textureId, byBuf);
                } else {
                    Inline.LOGGER.error("Unknown image type at url: " + url);
                }
            }
            catch (Exception e) {
                Inline.LOGGER.error("Failed to load texture from URL: " + url + "\n:" + String.valueOf(e));
            }
        });
        return null;
    }

    @Nullable
    public static class_3545<IntPair, SpriteUVLens> getTextureInfo(class_2960 textureId) {
        return TEXTURE_INFO.get(textureId);
    }

    public static class_3545<IntPair, SpriteUVLens> readGif(class_2960 loc, ByteBuffer buf) throws IOException {
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            PointerBuffer delayBuf = memoryStack.mallocPointer(1);
            IntBuffer wBuf = memoryStack.mallocInt(1);
            IntBuffer hBuf = memoryStack.mallocInt(1);
            IntBuffer framesBuf = memoryStack.mallocInt(1);
            IntBuffer channelsBuf = memoryStack.mallocInt(1);
            ByteBuffer imageBuf = STBImage.stbi_load_gif_from_memory((ByteBuffer)buf, (PointerBuffer)delayBuf, (IntBuffer)wBuf, (IntBuffer)hBuf, (IntBuffer)framesBuf, (IntBuffer)channelsBuf, (int)4);
            if (imageBuf == null) {
                throw new IOException("Could not load image here: " + STBImage.stbi_failure_reason());
            }
            class_1011 image = new class_1011(wBuf.get(0), hBuf.get(0) * framesBuf.get(0), true);
            MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)imageBuf), (long)((NativeImageAccessor)image).getPointer(), (long)((long)wBuf.get(0) * (long)hBuf.get(0) * (long)framesBuf.get(0) * 4L));
            class_1043 tex = new class_1043(image);
            int[] delays = new int[framesBuf.get(0)];
            delayBuf.getIntBuffer(framesBuf.get(0)).get(delays);
            class_3545 textInfo = new class_3545((Object)new IntPair(wBuf.get(0), hBuf.get(0) * framesBuf.get(0)), (Object)new SpriteUVLens.AnimUVLens(1.0 / (double)framesBuf.get(0), true, delays));
            class_310.method_1551().execute(() -> {
                class_310.method_1551().method_1531().method_4616(loc, (class_1044)tex);
                LOADED_TEXTURES.put(loc, loc);
                TEXTURE_INFO.put(loc, (class_3545<IntPair, SpriteUVLens>)textInfo);
                IN_PROGRESS_TEXTURES.remove(loc);
            });
            class_3545 class_35452 = textInfo;
            return class_35452;
        }
    }
}

