package com.samsthenerd.inline.utils.cradles;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.utils.EntityCradle;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2960;

/**
 * An entity cradle backed by an EntityType identifier.
 */
public class EntTypeCradle<E extends class_1297> extends EntityCradle {

    private static final HashMap<class_2960, class_1297> ENTITY_CACHE = new HashMap<>();

    private final class_1299<E> type;

    @Override
    public String getId(){
        return type.method_5882();
    }

    public EntTypeCradle(class_1299<E> type){
        this.type = type;
    }

    public static Optional<EntTypeCradle> fromTypeId(class_2960 id){
        return class_1299.method_5898(id.toString()).map(EntTypeCradle::new);
    }

    public class_1299<E> getEntType(){
        return type;
    }

    public CradleType<?> getType(){
        return EntTypeCradleType.INSTANCE;
    }

    public class_1297 getEntity(class_1937 world){
        class_2960 typeId = class_1299.method_5890(type);
        if(ENTITY_CACHE.containsKey(typeId)){
            return ENTITY_CACHE.get(typeId);
        }

        try{
            class_1297 newEnt = type.method_5883(world);
            ENTITY_CACHE.put(typeId, newEnt);
            return newEnt;
        } catch (Exception e){
            return null;
        }

    }

    private static class EntTypeCradleType implements CradleType<EntTypeCradle>{

        public static EntTypeCradleType INSTANCE = EntityCradle.addCradleType(new EntTypeCradleType());

        public class_2960 getId(){
            return Inline.id("enttype");
        }

        public Codec<EntTypeCradle> getCodec(){
            return class_2960.field_25139.comapFlatMap(
                (id) -> EntTypeCradle.fromTypeId(id).map(DataResult::success).orElse(DataResult.error(() -> "no entity type: " + id.toString())),
                (cradle) -> class_1299.method_5890(cradle.getEntType())
            );
        }
    }
}
