package com.samsthenerd.inline.tooltips.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.samsthenerd.inline.tooltips.data.SpriteTooltipData;
import com.samsthenerd.inline.utils.SpriteUVRegion;
import com.samsthenerd.inline.utils.Spritelike;
import com.samsthenerd.inline.utils.SpritelikeRenderers;
import java.util.function.BiFunction;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5684;

public class SpriteTooltipComponent implements class_5684 {
    public static final float DEFAULT_RENDER_SIZE = 96f;

    private Spritelike sprite;
    private BiFunction<Integer, Integer, Integer> widthProvider;

    public SpriteTooltipComponent(SpriteTooltipData tt) {
        this.sprite = tt.sprite;
        this.widthProvider = tt.widthProvider;
    }

    @Override
    public void method_32666(class_327 font, int mouseX, int mouseY, class_332 context) {
        // reload it just incase it failed the first time or whatever ?
        class_2960 textureId = sprite.getTextureId();
        if(textureId == null || textureId.equals(class_2960.method_60654(""))){
            return;
        }
        class_4587 ps = context.method_51448();
        ps.method_22903();
        ps.method_46416(mouseX, mouseY, 500);
        RenderSystem.setShaderColor(1f, 1f, 1f, 1f);
        
        SpritelikeRenderers.getRenderer(sprite).drawSprite(sprite, context, 0, 0, 0, method_32664(font), getRenderHeight());

        ps.method_22909();
    }

    @Override
    public int method_32664(class_327 pFont) {
        SpriteUVRegion uvs = sprite.getUVs();
        return widthProvider.apply(
            (int) (uvs.uWidth() * sprite.getTextureWidth()),
            (int) (uvs.vHeight() * sprite.getTextureHeight())
        );
    }

    private int getRenderHeight(){
        SpriteUVRegion uvs = sprite.getUVs();
        int realWidth = widthProvider.apply(
            (int) (uvs.uWidth() * sprite.getTextureWidth()),
            (int) (uvs.vHeight() * sprite.getTextureHeight())
        );
        if(realWidth == 0 || sprite.getTextureWidth() == 0){
            return 0;
        }
        return (int)(realWidth * ((double)sprite.getTextureHeight())/sprite.getTextureWidth());
    }

    @Override
    public int method_32661() {
        return getRenderHeight() + 4;
    }
}
