package com.samsthenerd.inline.api.data;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.impl.InlineStyle;
import com.samsthenerd.inline.tooltips.CustomTooltipManager;
import com.samsthenerd.inline.tooltips.providers.ModDataTTProvider;
import com.samsthenerd.inline.utils.Spritelike;
import com.samsthenerd.inline.utils.TextureSprite;
import com.samsthenerd.inline.utils.URLSprite;
import com.samsthenerd.inline.xplat.IModMeta;
import javax.annotation.Nullable;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import java.nio.file.Path;
import java.util.Optional;

// mostly just extending so we can still use the renderer
public class ModIconData extends SpriteInlineData{
    public ModIconDataType getType(){
        return ModIconDataType.INSTANCE;
    }

    public class_2960 getRendererId(){
        return Inline.id( "spritelike");
    }

    public static final Spritelike MISSING_ICON = new TextureSprite(Inline.id( "textures/missingicon.png"));

    public String modid;

    public ModIconData(String modid){
        this(modid, true);
    }

    public ModIconData(String modid, boolean usePlaceholder){
        super(spriteFromModid(modid, usePlaceholder));
        this.modid = modid;
    }

    @Nullable
    public static Spritelike spriteFromModid(String modid, boolean usePlaceholder){
        Optional<IModMeta> maybeMod = IModMeta.getMod(modid);
        if(maybeMod.isEmpty()){
            return usePlaceholder ? MISSING_ICON : null;
        }
        IModMeta mod = maybeMod.get();
        try {
            Optional<String> logoFile = mod.getLogoFile(128);
            if(logoFile.isEmpty()) return usePlaceholder ? MISSING_ICON : null;
            Optional<Path> logoPath = mod.findResource(logoFile.get());
            if(logoPath.isEmpty()) return usePlaceholder ? MISSING_ICON : null;
            return new URLSprite(logoPath.get().toUri().toURL().toString(), class_2960.method_60655("inlinemodicon", mod.getModId()));
        } catch (Exception e){
            return usePlaceholder ? MISSING_ICON : null;
        }
    }

    public static class_2583 getTooltipStyle(String modid){
        Optional<IModMeta> maybeMod = IModMeta.getMod(modid);
        if(maybeMod.isEmpty()){
            return class_2583.field_24360;
        }
        IModMeta mod = maybeMod.get();

        class_2568 he = new class_2568(
            class_2568.class_5247.field_24343, 
            new class_2568.class_5249(CustomTooltipManager.getForTooltip(ModDataTTProvider.INSTANCE, mod))
        ); 
        class_2583 styled = class_2583.field_24360.method_10949(he);
        Optional<String> homepageMaybe = mod.getHomepage();
        if(homepageMaybe.isPresent()){
            class_2558 ce = new class_2558(class_2558.class_2559.field_11749, homepageMaybe.get().toString());
            styled = styled.method_10958(ce);
        }
        return styled;
    }

    public static class_2561 makeModIcon(IModMeta mod){
        class_2583 dataStyle = InlineStyle.fromInlineData(new ModIconData(mod.getModId()));
        return class_2561.method_43470(".").method_10862(dataStyle.method_27702(getTooltipStyle(mod.getModId())));
    }

    public static class ModIconDataType extends SpriteDataType {
        public static ModIconDataType INSTANCE = new ModIconDataType();

        @Override
        public class_2960 getId(){
            return Inline.id( "modicon");
        }

        @Override
        public Codec<SpriteInlineData> getCodec(){
            return Codec.STRING.flatComapMap(
                ModIconData::new,
                (SpriteInlineData data) -> {
                    if(!(data instanceof ModIconData mData)) {
                        return DataResult.error(() -> "");
                    }
                    return DataResult.success(mData.modid);
                }
            );
        }
    }
}
