package com.samsthenerd.inline.api.data;

import com.mojang.serialization.Codec;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.impl.InlineStyle;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2568.class_5249;
import net.minecraft.class_2583;
import net.minecraft.class_2960;

public class ItemInlineData implements InlineData<ItemInlineData>{

    private class_1799 stack;

    @Override
    public ItemDataType getType(){
        return ItemDataType.INSTANCE;
    }

    @Override
    public class_2960 getRendererId(){
        return Inline.id( "item");
    }

    public class_1799 getStack(){
        return stack;
    }

    public ItemInlineData(class_1799 stack){
        this.stack = stack;
    }

    // gives a character that's styled to appear as the item, with the same hover event
    public static class_2561 make(class_1799 stack){
        class_2568 hover = new class_2568(class_2568.class_5247.field_24343, new class_5249(stack));
        class_2583 style = ((InlineStyle)class_2583.field_24360.method_10949(hover)).withInlineData(new ItemInlineData(stack));
        return class_2561.method_43470("#").method_10862(style);
    }

    public static class ItemDataType implements InlineDataType<ItemInlineData> {
        public static ItemDataType INSTANCE = new ItemDataType();

        @Override
        public class_2960 getId(){
            return Inline.id( "item");
        }

        @Override
        public Codec<ItemInlineData> getCodec(){
            return class_1799.field_24671.xmap(
                ItemInlineData::new,
                ItemInlineData::getStack
            );
        }
    }
}
