package com.samsthenerd.inline;

import com.samsthenerd.inline.api.InlineAPI;
import com.samsthenerd.inline.api.data.EntityInlineData.EntityDataType;
import com.samsthenerd.inline.api.data.ItemInlineData;
import com.samsthenerd.inline.api.data.ItemInlineData.ItemDataType;
import com.samsthenerd.inline.api.data.ModIconData.ModIconDataType;
import com.samsthenerd.inline.api.data.PlayerHeadData.PlayerHeadDataType;
import com.samsthenerd.inline.api.data.SpriteInlineData.SpriteDataType;
import com.samsthenerd.inline.api.matching.InlineMatch;
import com.samsthenerd.inline.api.matching.MatcherInfo;
import com.samsthenerd.inline.api.matching.RegexMatcher;
import com.samsthenerd.inline.api.matching.RegexMatcher.Standard;
import com.samsthenerd.inline.xplat.XPlatInstances;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;
import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_9334;

// this will probably be bumped out into its own mod Soon, but i want to get it working in this test environment first
public class Inline {

    public static final String MOD_ID = "inline";

    public static final Logger LOGGER = LoggerFactory.getLogger("inline");

    public static class_2960 id(String path){
        return class_2960.method_60655(MOD_ID, path);
    }

    public static XPlatInstances getXPlats(){
        return xPlats;
    }

	public static final void logPrint(String message){
        // if(IXPlatAbstractions.getInstance().isDevEnv())
			LOGGER.info(message);
	}

    private static XPlatInstances xPlats;

    public static void onInitialize(XPlatInstances xPlats){
        // nothing yet !
        Inline.xPlats = xPlats;
        registerDataTypes();
        addChatMatchers();
    }

    private static void registerDataTypes(){
        InlineAPI.INSTANCE.addDataType(EntityDataType.INSTANCE);
        InlineAPI.INSTANCE.addDataType(ItemDataType.INSTANCE);
        InlineAPI.INSTANCE.addDataType(ModIconDataType.INSTANCE);
        InlineAPI.INSTANCE.addDataType(PlayerHeadDataType.INSTANCE);
        InlineAPI.INSTANCE.addDataType(SpriteDataType.INSTANCE);
    }

    private static final Map<String, String> EQUIPMENT_ALIASES = Map.of(
        "hand", "mainhand", "chestplate", "chest", "leggings", "legs", "helmet", "head",
        "boots", "feet", "shoes", "feet"
    );
    private static void addChatMatchers(){
        class_2960 showOffID = class_2960.method_60655(Inline.MOD_ID, "showoff");
        RegexMatcher showOffMatcher = new RegexMatcher.ChatStandard("show", Standard.IDENTIFIER_REGEX_INSENSITIVE, showOffID,
                (whatToShow, ctx) -> {
                    class_1799 stack = null;
                    whatToShow = EQUIPMENT_ALIASES.getOrDefault(whatToShow, whatToShow);
                    try{
                        stack = ctx.getChatSender().method_6118(class_1304.method_5924(whatToShow));
                    } catch (Exception e){}
                    if(stack == null || stack.method_7960()){
                        stack = new class_1799(class_1802.field_8077);
                        stack.method_57379(class_9334.field_49631, class_2561.method_43471("ui.inline.nothingtoshowoff"));
                    }
                    class_2568 he = new class_2568(class_2568.class_5247.field_24343, new class_2568.class_5249(stack));
                    return new InlineMatch.DataMatch(new ItemInlineData(stack), class_2583.field_24360.method_10949(he));
                },
                MatcherInfo.fromId(showOffID)
        );
        InlineAPI.INSTANCE.addChatMatcher(showOffMatcher);
    }
}
