package com.samsthenerd.inline.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.AtomicDouble;
import com.mojang.blaze3d.systems.RenderSystem;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.api.client.GlowHandling;
import com.samsthenerd.inline.api.client.InlineClientAPI;
import com.samsthenerd.inline.api.client.InlineRenderer;
import com.samsthenerd.inline.mixin.core.MixinSetTessBuffer;
import com.samsthenerd.inline.utils.*;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

import java.time.Duration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2583;
import net.minecraft.class_289;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3545;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_6367;
import net.minecraft.class_8251;

public class InlineRenderCore {

    private static class_6367 GLOW_BUFF = new class_6367(128, 128, true, class_310.field_1703);

    private static Set<class_2960> ERRORED_RENDERERS = new HashSet<>();

    public static boolean textDrawerAcceptHandler(int index, class_2583 style, int codepoint, RenderArgs args) {
        InlineData inlData = style.getInlineData();
        if(inlData == null) return false;
        InlineRenderer renderer = InlineClientAPI.INSTANCE.getRenderer(inlData.getRendererId());
        if(renderer == null) return false;

        boolean noGlowHandle = !(renderer.getGlowPreference(inlData) instanceof GlowHandling.None);
        boolean hasGlowyMarker = style.getComponent(InlineStyle.GLOWY_MARKER_COMP);
        if(noGlowHandle && hasGlowyMarker){
            return true;
        }

        int glowColor = style.getComponent(InlineStyle.GLOWY_PARENT_COMP);
        boolean needsGlowChildren = glowColor != -1 && renderer.getGlowPreference(inlData) instanceof GlowHandling.Full;

        class_289 heldTess = class_289.method_1348();
        MixinSetTessBuffer.setInstance(secondaryTess);

        class_4597.class_4598 immToUse = args.provider() instanceof class_4597.class_4598 imm
                ? imm : VCPImmediateButImLyingAboutIt.of(args.provider());
        immToUse.method_22993();

        class_332 drawContext = new class_332(class_310.method_1551(), immToUse);
        class_4587 matrices = drawContext.method_51448();
        matrices.method_22903();

        double sizeMod = style.getComponent(InlineStyle.SIZE_MODIFIER_COMP);

        // note that we need to deal with position before normals now bc of matrixstack change.
        matrices.method_34425(args.matrix());
        matrices.method_34425(new Matrix4f().scale(1f, 1f, 0.001f));
        // there's almost certainly a better way to do this, but we're just flipping the y and z axes
        matrices.method_23760().method_23762().mul(new Matrix3f(1, 0, 0, 0, 0, 1, 0, 1, 0));
        // then inverting. idk why this is necessary.
        matrices.method_23760().method_23762().scale(-1);

        matrices.method_46416(args.x(), args.y(), 0);

        // only handle sizing here if sizing exists, renderer won't handle it, and player config says it's ok
        double maxSizeMod = InlineClientAPI.INSTANCE.getConfig().maxChatSizeModifier();
        if(sizeMod > maxSizeMod && com.samsthenerd.inline.api.client.InlineRenderer.isFlat(matrices, args.layerType) && com.samsthenerd.inline.api.client.InlineRenderer.isChatty()) sizeMod = maxSizeMod;

        boolean needToHandleSize = sizeMod != 1.0 && !renderer.handleOwnSizing(inlData);

        if(needToHandleSize){
            double yOffset = (sizeMod - 1) * 4; // sizeMod - 1 gives how much goes "outside" the main 8px. scale by 8 and then take half, so x4.
            matrices.method_22904(0, -yOffset, 0);
            matrices.method_22905((float)sizeMod, (float)sizeMod, 1f);
        }

        float alphaToUse = (args.alpha() == 0 ? 1 : args.alpha());

        int rendererARGB = class_5253.class_5254.method_27764(
                Math.round(alphaToUse* 255), Math.round(args.red() * 255),
                Math.round(args.green() * 255), Math.round(args.blue() * 255)
        );
        int usableColor = rendererARGB;
        if(style.method_10973() != null){
            usableColor = class_5253.class_5254.method_27763(rendererARGB, style.method_10973().method_27716() | 0xFF_000000);
        }

        InlineRenderer.TextRenderingContext trContext = new InlineRenderer.TextRenderingContext(args.light(), args.shadow(), args.brightnessMultiplier(),
                args.red(), args.green(), args.blue(), args.alpha() == 0 ? 1 : args.alpha(), args.layerType(), args.provider(), style.getComponent(InlineStyle.GLOWY_MARKER_COMP),
                style.getComponent(InlineStyle.GLOWY_PARENT_COMP), usableColor);

        if(!renderer.handleOwnTransparency(inlData)){
            RenderSystem.setShaderColor(1, 1, 1, alphaToUse);
        }

        try {
            if(needsGlowChildren){
                class_3545<Spritelike, Runnable> texResult = getGlowTextureSprite(inlData, renderer, immToUse, sizeMod, index, style, codepoint, trContext);
                Spritelike backSprite = texResult.method_15442();
                int brighterGlow = ColorUtils.ARGBtoHSB(glowColor)[2] > ColorUtils.ARGBtoHSB(usableColor)[2] ? glowColor : usableColor;
                SpritelikeRenderers.getRenderer(backSprite).drawSpriteWithLight(backSprite, drawContext, -2, -4, 0, 16, 16, trContext.light(), brighterGlow);
                texResult.method_15441().run(); // cleanup if needed
            }
            matrices.method_46416(0, 0, 10);
                args.xUpdater().addAndGet(renderer.render(inlData, drawContext, index, style, codepoint, trContext) * (needToHandleSize ? (float)sizeMod : 1f));

            immToUse.method_22993();
        } catch(Exception e){
            if(ERRORED_RENDERERS.add(inlData.getRendererId())){
                Inline.LOGGER.error("Error rendering inline with renderer: " + inlData.getRendererId().toString()
                    + " -- To prevent logspam this will only show once. This is likely an issue with whatever mod adds the renderer.");
            }
        }


        if(!renderer.handleOwnTransparency(inlData)){
            RenderSystem.setShaderColor(1f, 1f, 1f, 1f);
        }

        matrices.method_22909();

        MixinSetTessBuffer.setInstance(heldTess);

        return true;
    }

    private static final Cache<String, Spritelike> GLOW_TEXTURE_CACHE = CacheBuilder.newBuilder()
            .maximumSize(100) // should be a decent size ?
            .expireAfterAccess(Duration.ofMinutes(5))
            .removalListener((notif) -> {
                if(notif.getValue() instanceof TextureSprite tSprite){
                    class_310.method_1551().method_1531().method_4615(tSprite.getTextureId());
                }
            })
            .build();

    private static class_3545<Spritelike, Runnable> getGlowTextureSprite(InlineData inlData, InlineRenderer renderer, class_4597.class_4598 immToUse,
                                                                   double sizeMod, int index, class_2583 style, int codepoint, InlineRenderer.TextRenderingContext trContext){

        double outlineScaleBack = 1 / sizeMod;
        boolean needToHandleSize = sizeMod != 1.0 && !renderer.handleOwnSizing(inlData);

        // this should never happen, i'm just casting
        if(!(renderer.getGlowPreference(inlData) instanceof GlowHandling.Full fullHandling)) return null;

        String texCacheId = null;
        if(fullHandling.cacheId != null){
            texCacheId = "inlineglowtexture" + renderer.getId().method_42094() + "." + fullHandling.cacheId + sizeMod; // should sizemod even be here ?
            Spritelike texSpriteMaybe = GLOW_TEXTURE_CACHE.getIfPresent(texCacheId);
            if(texSpriteMaybe != null){
                return new class_3545<>(texSpriteMaybe, () -> {});
            }
        }

        int resScale = 8;
        GLOW_BUFF.method_1236(0, 0, 0, 0);
        GLOW_BUFF.method_1230(false);
        class_310.method_1551().method_1522().method_1240();
        Matrix4fStack mvStack = RenderSystem.getModelViewStack();
        Matrix4f backupProjMatrix = RenderSystem.getProjectionMatrix();
        mvStack.pushMatrix();
        mvStack.identity();
        RenderSystem.applyModelViewMatrix();
        class_8251 backupVertexSorter = RenderSystem.getVertexSorting();
        RenderSystem.backupProjectionMatrix();
        Matrix4f newProjMatrix = new Matrix4f();
        newProjMatrix.identity();
        newProjMatrix.setOrtho(0, 16*resScale, 0,16*resScale, 0, 100);
        RenderSystem.setProjectionMatrix(newProjMatrix, class_8251.field_43360);
        GLOW_BUFF.method_1235(true);
        class_332 glowContext = new class_332(class_310.method_1551(), immToUse);
        class_4587 glowStack = glowContext.method_51448();

        glowStack.method_22903();
        glowStack.method_46416(2*resScale, 4 * resScale, -50);
        glowStack.method_22905(resScale, resScale, 1f);
        glowStack.method_34425(new Matrix4f().scale(1, 1, 0.01f));
        float xOffsetDiff = renderer.render(inlData, glowContext, index, style, codepoint, trContext) * (needToHandleSize ? (float)sizeMod : 1f);
//            args.xUpdater().addAndGet(xOffsetDiff);

        immToUse.method_22993();

        mvStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setProjectionMatrix(backupProjMatrix, backupVertexSorter);
        GLOW_BUFF.method_1240();

        try (class_1011 nativeImage = new class_1011(16*resScale, 16*resScale, true)) {
            GLOW_BUFF.method_35610();
            nativeImage.method_4327(0, false);
            GLOW_BUFF.method_1242();
//                nativeImage.writeTo(MinecraftClient.getInstance().runDirectory.toPath().resolve("boop.png"));
//                nativeImage.apply(original -> ColorHelper.Argb.getAlpha(original) << 24 | 0x00_FFFFFF);
            class_1011 fullImage = new class_1011(nativeImage.method_4307(), nativeImage.method_4323(), true);
            int outlineRange = (int)Math.round(resScale * outlineScaleBack);
            // would
            Queue<Integer> pixelQueue = new LinkedList<>(); // bfs guarantees that we only hit each one once
            Int2IntMap seenPixels = new Int2IntOpenHashMap(); // x + y * width -> distance from an original
            // do an initial sweep for starting ones
            int imgWidth = nativeImage.method_4307();
            int imgHeight = nativeImage.method_4323();
            for(int px = 0; px < imgWidth; px++){
                for(int py = 0; py < imgHeight; py++){
                    if(class_5253.class_5254.method_27762(nativeImage.method_4315(px, py)) == 0) continue;
                    int thisPos = px + py *imgWidth;
                    seenPixels.put(thisPos, 0);
                    pixelQueue.add(thisPos);
                }
            }
            nativeImage.close();
            while(!pixelQueue.isEmpty()){
                int cPix = pixelQueue.poll(); // get current pixel to process;
                int cX = cPix % imgWidth;
                int cY = cPix / imgWidth;
                fullImage.method_4305(cX, cY, 0xFF_FFFFFF);
                if(seenPixels.get(cPix) >= outlineRange) continue; // exit out if we don't need to add neighbors
                for(int i = -1; i <= 1; i++){
                    if( cX + i < 0 || cX + i >= imgWidth) continue;
                    for(int j = -1; j <= 1; j++){
                        if( cY + j < 0 || cY + j >= imgHeight) continue;
                        int nbrPos = cPix + i + j * imgWidth;
                        if(!seenPixels.containsKey(nbrPos)){
                            seenPixels.put(nbrPos, seenPixels.get(cPix)+1);
                            pixelQueue.add(nbrPos);
                        }
                    }
                }
            }

            class_310.method_1551().method_1522().method_1235(true);
            if(texCacheId != null){
                class_2960 backTexId = class_310.method_1551().method_1531().method_4617(
                        texCacheId,
                        new class_1043(fullImage));
                TextureSprite tSprite = new TextureSprite(backTexId);
                GLOW_TEXTURE_CACHE.put(texCacheId, tSprite);
                return new class_3545<>(tSprite, () -> {});
            } else {
                class_2960 backTexId = class_310.method_1551().method_1531().method_4617(Inline.id("glowtextureback").method_42094(), new class_1043(fullImage));
                return new class_3545<>(new TextureSprite(backTexId), () -> {
                    class_310.method_1551().method_1531().method_4615(backTexId);
                });
            }
        } catch (Exception e){
            Inline.LOGGER.error(e.toString());
        }
        return null;
    }

    private static final class_289 secondaryTess = new class_289();

    public record RenderArgs(float x, float y, Matrix4f matrix, int light, boolean shadow, float brightnessMultiplier,
                                    float red, float green, float blue, float alpha, class_327.class_6415 layerType,
                                    class_4597 provider, AtomicDouble xUpdater){}
}
