package com.samsthenerd.inline.api.data;

import com.mojang.serialization.Codec;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.tooltips.CustomTooltipManager;
import com.samsthenerd.inline.tooltips.providers.EntityTTProvider;
import com.samsthenerd.inline.utils.EntityCradle;
import com.samsthenerd.inline.utils.cradles.EntTypeCradle;
import com.samsthenerd.inline.utils.cradles.NbtCradle;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5819;

public class EntityInlineData implements InlineData<EntityInlineData>{

    protected static final class_5819 random = class_5819.method_43047();
    protected float uniqueOffset = 0;
    public final EntityCradle cradle;

    public EntityInlineData(EntityCradle cradle){
        this.cradle = cradle;
    }

    public static EntityInlineData fromEntity(class_1297 entity){
        return new EntityInlineData(new NbtCradle(entity));
    }

    public static EntityInlineData fromNbt(class_2487 tag){
        return new EntityInlineData(new NbtCradle(tag));
    }

    public static EntityInlineData fromType(class_1299 type){
        return new EntityInlineData(new EntTypeCradle(type));
    }

    @Override
    public EntityDataType getType(){
        return EntityDataType.INSTANCE;
    }

    @Override
    public class_2960 getRendererId(){
        return new class_2960(Inline.MOD_ID, "entity");
    }

    @Nullable
    public class_1297 getEntity(class_1937 world){
        return cradle.getEntity(world);
    }

    public float getUniqueOffset(){
        return uniqueOffset;
    }

    public class_2568 getEntityDisplayHoverEvent(){
        return new class_2568(
            class_2568.class_5247.field_24343, 
            new class_2568.class_5249(CustomTooltipManager.getForTooltip(EntityTTProvider.INSTANCE, cradle))
        ); 
    }

    public class_2583 getDataStyle(boolean withAdditional){
        class_2583 superStyle = InlineData.super.asStyle(withAdditional);
        if(!withAdditional) return superStyle;
        return superStyle.method_27702(class_2583.field_24360.method_10949(getEntityDisplayHoverEvent()));
    }

    public static class EntityDataType implements InlineDataType<EntityInlineData> {
        public static EntityDataType INSTANCE = new EntityDataType();

        @Override
        public class_2960 getId(){
            return new class_2960(Inline.MOD_ID, "entity");
        }

        @Override
        public Codec<EntityInlineData> getCodec(){
            return EntityCradle.CRADLE_CODEC.xmap(
                EntityInlineData::new,
                data -> data.cradle
            );
        }
    }
}

