package com.samsthenerd.inline.registry;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_5632;
import net.minecraft.class_5684;
import com.samsthenerd.inline.tooltips.CustomTooltipManager;
import com.samsthenerd.inline.tooltips.components.EntityDisplayTTComp;
import com.samsthenerd.inline.tooltips.components.SpriteTooltipComponent;
import com.samsthenerd.inline.tooltips.data.EntityDisplayTTData;
import com.samsthenerd.inline.tooltips.data.SpriteTooltipData;
import com.samsthenerd.inline.tooltips.providers.EntityTTProvider;
import com.samsthenerd.inline.tooltips.providers.ModDataTTProvider;

public class InlineTooltips {

    public static final Map<Class<? extends class_5632>, Function<class_5632, class_5684>> tooltipDataToComponent = new HashMap<>();

    public static class_5684 getTooltipComponent(class_5632 data){
        Function<class_5632, class_5684> ttFunc = tooltipDataToComponent.get(data.getClass());
        return ttFunc == null ? null : ttFunc.apply(data);
    }

    public static <C extends class_5684, D extends class_5632> Function<class_5632, C> convertTooltip(Class<D> dataClass, 
        Function<D, C> componentFactory){
        return (data) -> {
            if(dataClass.isInstance(data)){
                return componentFactory.apply(dataClass.cast(data));
            }
            return null;
        };
    }

    // should be called sided in tooltip registration stuff
    public static void init(){
        tooltipDataToComponent.put(SpriteTooltipData.class, convertTooltip(SpriteTooltipData.class, SpriteTooltipComponent::new));
        tooltipDataToComponent.put(EntityDisplayTTData.class, convertTooltip(EntityDisplayTTData.class, EntityDisplayTTComp::new));
        CustomTooltipManager.registerProvider(ModDataTTProvider.INSTANCE);
        CustomTooltipManager.registerProvider(EntityTTProvider.INSTANCE);
    }
}
