package com.samsthenerd.inline.api.client.renderers;

import com.mojang.authlib.GameProfile;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.client.GlowHandling;
import com.samsthenerd.inline.api.client.InlineRenderer;
import com.samsthenerd.inline.api.data.PlayerHeadData;
import com.samsthenerd.inline.api.data.SpriteInlineData;
import com.samsthenerd.inline.utils.FakeClientPlayerMaker;
import com.samsthenerd.inline.utils.TextureSprite;
import net.minecraft.class_1068;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4844;

public class PlayerHeadRenderer implements InlineRenderer<PlayerHeadData>{

    public static final PlayerHeadRenderer INSTANCE = new PlayerHeadRenderer();

    @Override
    public class_2960 getId(){
        return new class_2960(Inline.MOD_ID, "playerhead");
    }

    public class_2960 textureFromHeadData(PlayerHeadData data){
        GameProfile prof = FakeClientPlayerMaker.getBetterProfile(data.profile);
        class_2960 skinTextId;
        if(prof == null){
            // get a steve head i guess
            skinTextId = class_1068.method_4648(class_4844.method_43343(data.profile));
        } else {
            skinTextId = class_310.method_1551().method_1582().method_44705(prof);
        }
        return skinTextId;
    }

    public SpriteInlineData getFace(PlayerHeadData data){
        TextureSprite faceSprite = TextureSprite.fromPixels(textureFromHeadData(data),
            8, 8, 8, 8, 64, 64);
        return new SpriteInlineData(faceSprite);
    }

    public SpriteInlineData getOuter(PlayerHeadData data){
        TextureSprite faceSprite = TextureSprite.fromPixels(textureFromHeadData(data),
            40, 8, 8, 8, 64, 64);
        return new SpriteInlineData(faceSprite);
    }

    @Override
    public int render(PlayerHeadData data, class_332 context, int index, class_2583 style, int codepoint, TextRenderingContext trContext){
        SpriteInlineData faceSpriteData = getFace(data);
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_22904(0.25, 0.25, 0);
        matrices.method_22905(8/(float)8.5, 8/(float)8.5,1);
        InlineSpriteRenderer.INSTANCE.render(faceSpriteData, context, index, style, codepoint, trContext);
        matrices.method_22909();
        SpriteInlineData outerSpriteData = getOuter(data);
        matrices.method_22903();
        matrices.method_46416(0, 0, 10);
        int res = InlineSpriteRenderer.INSTANCE.render(outerSpriteData, context, index, style, codepoint, trContext);
        matrices.method_22909();
        return res;
    }

    @Override
    public int charWidth(PlayerHeadData data, class_2583 style, int codepoint){
        return 8;
    }

    @Override
    public GlowHandling getGlowPreference(PlayerHeadData forData){
        // silly but should be fine.
        if(forData.profile.getName() != null){
            return new GlowHandling.Full(forData.profile.getName().toLowerCase());
        }
        if(forData.profile.getId() != null){
            return new GlowHandling.Full(forData.profile.getId().toString().toLowerCase());
        }
        return new GlowHandling.Full();
    }
}
