package com.samsthenerd.inline.mixin.feature;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_7923;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.samsthenerd.inline.api.client.InlineClientAPI;
import com.samsthenerd.inline.api.data.ModIconData;
import com.samsthenerd.inline.xplat.IModMeta;

@Mixin(value = class_1799.class, priority = 10000)
public class MixinAddModIconToTooltip {
    @ModifyReturnValue(
        method="getTooltip(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/client/item/TooltipContext;)Ljava/util/List;",
        at = @At("RETURN")
    )
    private List<class_2561> findAndAddModIcon(List<class_2561> originalTT){
        if(!InlineClientAPI.INSTANCE.getConfig().shouldRenderModIcons()) return originalTT;
        class_1799 thisStack = (class_1799)((Object)this);
        // probably modid !
        String modNamespace = class_7923.field_41178.method_10221(thisStack.method_7909()).method_12836();
        if(modNamespace.equals("") || modNamespace.equals("minecraft")){
            return originalTT;
        }
        Optional<IModMeta> maybeMod = IModMeta.getMod(modNamespace);
        if(maybeMod.isEmpty()){
            return originalTT;
        }
        IModMeta mod = maybeMod.get();
        String modName = mod.getName();
        List<class_2561> newTT = new ArrayList<>();
        for(class_2561 comp : originalTT){
            if(comp.getString().equals(modName)){
                newTT.add(comp.method_27661().method_10852(class_2561.method_43470(" ")).method_10852(ModIconData.makeModIcon(mod)));
            } else {
                newTT.add(comp);
            }
        }
        return newTT;
    }
}
