package com.samsthenerd.inline.utils.cradles;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.utils.EntityCradle;
import com.samsthenerd.inline.utils.FakeClientPlayerMaker;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_4844;

/**
 * An entity cradle backed by a player GameProfile
 */
public class PlayerCradle extends EntityCradle {

    private static final HashMap<UUID, class_1297> UUID_PLAYER_CACHE = new HashMap<>();
    private static final HashMap<String, class_1297> NAME_PLAYER_CACHE = new HashMap<>();

    public static final Codec<GameProfile> GAME_PROFILE_CODEC = Codec.either(
            Codec.STRING.fieldOf("username").codec(), 
            class_4844.field_40825.fieldOf("uuid").codec()
        ).xmap(
            (nameOrId) -> nameOrId.map(
                name -> new GameProfile(null, name), 
                uuid -> new GameProfile(uuid, null)),
            
            (profile) -> {
                String name = profile.getName();
                if(name != null && !name.isEmpty()){
                    return Either.left(name);
                }
                return Either.right(profile.getId());
            }
        );

    private GameProfile profile;

    public PlayerCradle(GameProfile profile){
        this.profile = profile;
    }

    public GameProfile getProfile(){
        return profile;
    }

    public CradleType<?> getType(){
        return PlayerCradleType.INSTANCE;
    }

    @Override
    public String getId(){
        return profile.getId() == null ? profile.getName() : profile.getId().toString();
    }

    public class_1297 getEntity(class_1937 world){
        UUID playerId = profile.getId();
        if(playerId != null && UUID_PLAYER_CACHE.containsKey(playerId)){
            return UUID_PLAYER_CACHE.get(playerId);
        }
        String playerName = profile.getName();
        if(playerName != null && !playerName.equals("") && NAME_PLAYER_CACHE.containsKey(playerName)){
            return NAME_PLAYER_CACHE.get(playerName);
        }

        if(!world.method_8608()){
            return null;
        }
        
        class_3545<class_1297, Boolean> playerRes = FakeClientPlayerMaker.getPlayerEntity(profile);
        if(playerRes.method_15441() && playerId != null){
            UUID_PLAYER_CACHE.put(playerId, playerRes.method_15442());
        }
        if(playerRes.method_15441() && playerName != null && !playerName.equals("")){
            NAME_PLAYER_CACHE.put(playerName, playerRes.method_15442());
        }
        return playerRes.method_15442();
    }

    private static class PlayerCradleType implements CradleType<PlayerCradle>{

        public static PlayerCradleType INSTANCE = EntityCradle.addCradleType(new PlayerCradleType());

        public class_2960 getId(){
            return new class_2960(Inline.MOD_ID, "nbt");
        }

        public Codec<PlayerCradle> getCodec(){
            return GAME_PROFILE_CODEC.xmap(
                PlayerCradle::new,
                PlayerCradle::getProfile
            );
        }
    }
}
