package com.samsthenerd.inline.tooltips.components;

import java.util.function.BiFunction;
import net.minecraft.class_1297;
import net.minecraft.class_238;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5684;
import net.minecraft.class_765;
import net.minecraft.class_7833;
import net.minecraft.class_897;
import com.samsthenerd.inline.tooltips.data.EntityDisplayTTData;
import com.samsthenerd.inline.utils.EntityCradle;

public class EntityDisplayTTComp implements class_5684 {
    public static final float DEFAULT_RENDER_SIZE = 96f;

    private EntityCradle cradle;
    private BiFunction<Integer, Integer, Integer> widthProvider;

    public EntityDisplayTTComp(EntityDisplayTTData tt) {
        this.cradle = tt.cradle;
        this.widthProvider = tt.widthProvider;
    }

    @Override
    public void method_32666(class_327 font, int mouseX, int mouseY, class_332 context) {
        // reload it just incase it failed the first time or whatever ?
        class_1297 ent = cradle.getEntity(class_310.method_1551().field_1687);
        if(ent == null) return;

        class_238 bounds = ent.method_5829().method_1009(0, 0.05, 0);

        double height = bounds.method_17940();

        float rot = 15f;

        class_897 renderer = class_310.method_1551().method_1561().method_3953(ent);
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        int rHeight = getRenderHeight();
        int ttWidth = method_32664(font);
        matrices.method_22904(mouseX + ttWidth/2.0, mouseY, 500);
        float scaleFactor = (float)(rHeight/height);
        matrices.method_22905(scaleFactor, -scaleFactor, scaleFactor);
        matrices.method_22904(0, -height, 0);
        class_310 client = class_310.method_1551();
        float tickDelta = client.method_1488();
        // float rotation = 90f * (Util.getMeasuringTimeMs() / 1000f + data.getUniqueOffset());
        matrices.method_22907(class_7833.field_40716.rotationDegrees(rot));
        renderer.method_3936(ent, 0, 0, matrices, context.method_51450(), class_765.field_32767);
        matrices.method_22909();
    }

    @Override
    public int method_32664(class_327 pFont) {
        class_1297 ent = cradle.getEntity(class_310.method_1551().field_1687);
        if(ent == null) return 0;

        // Box bounds = ent.getBoundingBox().expand(0.15, 0.1, 0.15);
        class_238 bounds = ent.method_5829().method_1009(0, 0.05, 0);

        double width = bounds.method_17939();
        double depth = bounds.method_17941();
        double height = bounds.method_17940();

        float rot = 15f;
        double radRot = Math.toRadians(rot % 90);
        double pWidth = (width * Math.cos(radRot)) + (depth * Math.sin(radRot));

        return (int) (widthProvider.apply(
            (int) (pWidth*100),
            (int) (height*100)
        )) + 16;
    }

    private int getRenderHeight(){
        class_1297 ent = cradle.getEntity(class_310.method_1551().field_1687);
        if(ent == null) return 0;

        class_238 bounds = ent.method_5829().method_1009(0, 0.05, 0);

        double width = bounds.method_17939();
        double depth = bounds.method_17941();
        double height = bounds.method_17940();

        float rot = 15f;
        double radRot = Math.toRadians(rot % 90);
        double pWidth = (width * Math.cos(radRot)) + (depth * Math.sin(radRot));

        int realWidth = widthProvider.apply(
            (int) (pWidth*100),
            (int) (height*100)
        );
        if(pWidth == 0){
            return 0;
        }
        return (int)(realWidth * (height / pWidth));
    }

    @Override
    public int method_32661() {
        return getRenderHeight() + 4; 
    }
}
