package com.samsthenerd.inline.api.client.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.client.GlowHandling;
import com.samsthenerd.inline.api.client.InlineRenderer;
import com.samsthenerd.inline.api.data.SpriteInlineData;
import com.samsthenerd.inline.utils.SpriteUVRegion;
import com.samsthenerd.inline.utils.SpritelikeRenderers;
import java.util.Objects;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class InlineSpriteRenderer implements InlineRenderer<SpriteInlineData>{

    public static final InlineSpriteRenderer INSTANCE = new InlineSpriteRenderer();

    public class_2960 getId(){
        return new class_2960(Inline.MOD_ID, "spritelike");
    
    }

    public int render(SpriteInlineData data, class_332 context, int index, class_2583 style, int codepoint, TextRenderingContext trContext){
        if(data == null || data.sprite == null) return 0;
        SpriteUVRegion uvs = data.sprite.getUVs();
        double height = uvs.vHeight() * data.sprite.getTextureHeight();
        if(height == 0){
            return 0;
        }
        double width = uvs.uWidth() * data.sprite.getTextureWidth();
        float whRatio = (float) (width / height);
        class_4587 matrices = context.method_51448();
        matrices.method_46416(0, 0, 1);
        RenderSystem.enableDepthTest();
        SpritelikeRenderers.getRenderer(data.sprite).drawSpriteWithLight(data.sprite, context, 0, 0, 0, 8 * whRatio,8, trContext.light(),
            data.shouldTint ? trContext.usableColor() : 0xFFFFFFFF);
        return (int)Math.ceil(whRatio * 8);
    }

    public int charWidth(SpriteInlineData data, class_2583 style, int codepoint){
        if(data == null || data.sprite == null) return 0;
        SpriteUVRegion uvs = data.sprite.getUVs();
        double height = uvs.vHeight() * data.sprite.getTextureHeight();
        if(height == 0){
            return 0;
        }
        double width = uvs.uWidth() * data.sprite.getTextureWidth();
        float whRatio = (float) (width / height);
        return (int)Math.ceil(8.0 * whRatio);
    }

    // spritelikes aren't really built to handle animated sprites so it's fine.
    @Override
    public GlowHandling getGlowPreference(SpriteInlineData forData){
        return new GlowHandling.Full(Objects.requireNonNullElse(forData.sprite.getTextureId(), new class_2960("")).method_42094() + Integer.toHexString(forData.sprite.hashCode()).toLowerCase());
    }
}
