package com.samsthenerd.inline.mixin.feature;

import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_5632;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.samsthenerd.inline.tooltips.CustomTooltipManager;

// slightly lower priority in case other mods try to modify it.
@Mixin(value = class_1799.class, priority = 5000)
public class MixinHijackFeatherForTooltip {
    @ModifyReturnValue(
        method="getTooltip(Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/client/item/TooltipContext;)Ljava/util/List;",
        at = @At("RETURN")
    )
    private List<class_2561> hijackFeatherTooltipText(List<class_2561> originalTT){
        return getTooltipSomething(CustomTooltipManager::getTooltipText, originalTT);
    }

    @ModifyReturnValue(
        method="getTooltipData()Ljava/util/Optional;",
        at = @At("RETURN")
    )
    private Optional<class_5632> hijackFeatherTooltipData(Optional<class_5632> originalTT){
        return getTooltipSomething(CustomTooltipManager::getTooltipData, originalTT);
    }

    private <T> T getTooltipSomething(Function<class_1799, T> ttGetter, T originalTT){
        class_1799 thisStack = (class_1799)((Object)this);
        if(thisStack.method_7909() == CustomTooltipManager.HIJACKED_ITEM){
            T newTT = ttGetter.apply(thisStack);
            if(newTT != null){
                return newTT;
            }
        }
        return originalTT;
    }
}
