/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.network.locator;

import java.util.HashMap;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class PlayerInventoryFinder {
    public static String MAIN = "main_inventory";
    public static HashMap<String, PlayerInventoryFinder> FINDERS = new HashMap();
    private final Function<Player, Integer> slotAmountGetter;
    private final BiFunction<Player, Integer, ItemStack> stackGetter;
    private final IStackModifier stackSetter;

    public static Optional<PlayerInventoryFinder> get(String name) {
        return Optional.ofNullable(FINDERS.get(name));
    }

    public PlayerInventoryFinder(Function<Player, Integer> slotAmountGetter, BiFunction<Player, Integer, ItemStack> stackGetter, IStackModifier stackSetter) {
        this.slotAmountGetter = slotAmountGetter;
        this.stackGetter = stackGetter;
        this.stackSetter = stackSetter;
    }

    public Function<Player, Integer> getSlotAmountGetter() {
        return this.slotAmountGetter;
    }

    public BiFunction<Player, Integer, ItemStack> getStackGetter() {
        return this.stackGetter;
    }

    public IStackModifier getStackSetter() {
        return this.stackSetter;
    }

    public static void init() {
    }

    static {
        FINDERS.put(MAIN, new PlayerInventoryFinder(playerEntity -> playerEntity.getInventory().items.size(), (playerEntity, integer) -> playerEntity.getSlot(integer.intValue()).get(), (playerEntity, slot, stack) -> playerEntity.getSlot(slot).set(stack)));
    }

    public static interface IStackModifier {
        public void consume(Player var1, int var2, ItemStack var3);
    }

    public static class Target {
        private final String name;
        private final PlayerInventoryFinder finder;
        private final int slot;

        public Target(String name, PlayerInventoryFinder finder, int slot) {
            this.name = name;
            this.finder = finder;
            this.slot = slot;
        }

        public String getName() {
            return this.name;
        }

        public PlayerInventoryFinder getFinder() {
            return this.finder;
        }

        public int getSlot() {
            return this.slot;
        }
    }
}

