/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.recipe.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.neoforged.neoforge.common.conditions.ICondition;

public record ContentExistsCondition<T>(HolderGetter<T> registry, ResourceKey<T> contentName) implements ICondition
{
    public static final MapCodec<ContentExistsCondition<?>> CODEC = RecordCodecBuilder.mapCodec(in -> in.group((App)ResourceLocation.CODEC.fieldOf("registry").forGetter(ce -> ce.contentName().registry()), (App)ResourceLocation.CODEC.fieldOf("name").forGetter(ce -> ce.contentName().location()), (App)ExtraCodecs.retrieveContext(ops -> {
        DataResult dataResult;
        if (ops instanceof RegistryOps) {
            RegistryOps rops = (RegistryOps)ops;
            dataResult = DataResult.success((Object)rops);
        } else {
            dataResult = DataResult.error(() -> "Not a registry ops");
        }
        return dataResult;
    }).forGetter(ce -> null)).apply((Applicative)in, (reg, name, ops) -> {
        ResourceKey regKey = ResourceKey.createRegistryKey((ResourceLocation)reg);
        return new ContentExistsCondition((HolderGetter)ops.getter(regKey).orElseThrow(), ResourceKey.create((ResourceKey)regKey, (ResourceLocation)name));
    }));
    public static final ResourceLocation NAME = ResourceLocation.fromNamespaceAndPath((String)"titanium", (String)"content_exists");

    public boolean test(ICondition.IContext context) {
        return this.registry.get(this.contentName).isPresent();
    }

    public MapCodec<? extends ICondition> codec() {
        return CODEC;
    }
}

