/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.block.tile;

import com.google.common.collect.Sets;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.container.addon.IContainerAddon;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class PoweredTile<T extends PoweredTile<T>>
extends ActiveTile<T> {
    @Save
    private final EnergyStorageComponent<T> energyStorage = this.createEnergyStorage();
    private boolean showEnergy = true;

    public PoweredTile(BasicTileBlock<T> base, BlockEntityType<?> blockEntityType, BlockPos pos, BlockState state) {
        super(base, blockEntityType, pos, state);
        this.energyStorage.setComponentHarness((PoweredTile)this.getSelf());
    }

    @Nonnull
    public EnergyStorageComponent<T> getEnergyStorage() {
        return this.energyStorage;
    }

    @Nonnull
    protected EnergyStorageComponent<T> createEnergyStorage() {
        return new EnergyStorageComponent(10000, 4, 10);
    }

    public Set<Direction> getValidEnergyFaces() {
        return Sets.newHashSet((Object[])Direction.values());
    }

    @Override
    @Nonnull
    public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
        List<IFactory<? extends IScreenAddon>> screenAddons = super.getScreenAddons();
        if (this.showEnergy) {
            screenAddons.addAll(this.getEnergyStorage().getScreenAddons());
        }
        return screenAddons;
    }

    @Override
    @Nonnull
    public List<IFactory<? extends IContainerAddon>> getContainerAddons() {
        List<IFactory<? extends IContainerAddon>> containerAddons = super.getContainerAddons();
        if (this.showEnergy) {
            containerAddons.addAll(this.getEnergyStorage().getContainerAddons());
        }
        return containerAddons;
    }

    public void setShowEnergy(boolean showEnergy) {
        this.showEnergy = showEnergy;
    }
}

