/*
 * Decompiled with CFR 0.152.
 */
package com.hrznstudio.titanium.client.screen;

import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.client.AssetTypes;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.api.client.assets.types.IBackgroundAsset;
import com.hrznstudio.titanium.client.screen.IScreenAddonConsumer;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.lwjgl.glfw.GLFW;

public abstract class ScreenAddonScreen
extends Screen
implements IScreenAddonConsumer {
    public int x;
    public int y;
    private IAssetProvider assetProvider;
    private List<IScreenAddon> addonList;
    private boolean drawBackground;
    private boolean isMouseDragging;
    private int dragX;
    private int dragY;

    public ScreenAddonScreen(IAssetProvider assetProvider, boolean drawBackground) {
        super((Component)Component.literal((String)""));
        this.assetProvider = assetProvider;
        this.drawBackground = drawBackground;
    }

    public void init() {
        super.init();
        IBackgroundAsset background = IAssetProvider.getAsset(this.assetProvider, AssetTypes.BACKGROUND);
        this.x = this.width / 2 - background.getArea().width / 2;
        this.y = this.height / 2 - background.getArea().height / 2;
        this.addonList = this.guiAddons().stream().map(IFactory::create).collect(Collectors.toList());
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderForeground(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.checkForMouseDrag(mouseX, mouseY);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.drawBackground) {
            super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
            AssetUtil.drawAsset(guiGraphics, this, this.assetProvider.getAsset(AssetTypes.BACKGROUND), this.x, this.y);
        }
        this.addonList.forEach(iGuiAddon -> iGuiAddon.drawBackgroundLayer(guiGraphics, this, this.assetProvider, this.x, this.y, mouseX, mouseY, partialTicks));
    }

    public void renderForeground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.addonList.forEach(iGuiAddon -> iGuiAddon.drawForegroundLayer(guiGraphics, this, this.assetProvider, this.x, this.y, mouseX, mouseY, partialTicks));
        for (IScreenAddon iScreenAddon : this.addonList) {
            if (!iScreenAddon.isMouseOver(mouseX - this.x, mouseY - this.y) || iScreenAddon.getTooltipLines().isEmpty()) continue;
            guiGraphics.renderComponentTooltip(Minecraft.getInstance().font, iScreenAddon.getTooltipLines(), mouseX, mouseY);
        }
    }

    public abstract List<IFactory<IScreenAddon>> guiAddons();

    private void checkForMouseDrag(int mouseX, int mouseY) {
        int pressedButton = GLFW.glfwGetMouseButton((long)Minecraft.getInstance().getWindow().getWindow(), (int)0);
        if (pressedButton == 1) {
            if (!this.isDragging()) {
                this.setDragging(true);
            } else {
                for (IScreenAddon iScreenAddon : this.addonList) {
                    if (!iScreenAddon.isMouseOver(mouseX - this.x, mouseY - this.y)) continue;
                    iScreenAddon.mouseDragged(mouseX - this.x, mouseY - this.y, pressedButton, this.dragX, this.dragY);
                }
            }
            this.dragX = mouseX;
            this.dragY = mouseY;
        } else {
            this.setDragging(false);
        }
    }

    public List<IScreenAddon> getAddons() {
        return this.addonList;
    }

    public List<? extends GuiEventListener> children() {
        ArrayList children = new ArrayList(super.children());
        children.addAll(this.getAddons());
        return children;
    }
}

