package com.faux.customentitydata.mixin;

import com.faux.customentitydata.api.playersaves.IPlayerLoadListener;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_29;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_8942;

@Mixin(class_3324.class)
public class MixinPlayerList {

    @Final
    @Shadow
    private class_29 playerIo;

    @Inject(method = "load", at = @At("RETURN"))
    private void onPlayerLoad(class_3222 player, class_8942 problemReporter, CallbackInfoReturnable<Optional<class_11368>> cir) {

        if (this.playerIo instanceof AccessorPlayerDataStorage accessor) {

            IPlayerLoadListener.EVENT.invoker().loadPlayerData(player, accessor.faux$getSaveDir().toPath());
        }
    }
}