/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.apihandlers.plant;

import com.buuz135.industrial.api.plant.PlantRecollectable;
import com.buuz135.industrial.utils.BlockUtils;
import com.buuz135.industrial.utils.apihandlers.plant.TreeCache;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class TreePlantRecollectable
extends PlantRecollectable {
    private final HashMap<BlockPos, TreeCache> treeCache = new HashMap();

    public TreePlantRecollectable() {
        super("tree");
    }

    @Override
    public boolean canBeHarvested(Level world, BlockPos pos, BlockState blockState) {
        if (this.treeCache.containsKey(pos)) {
            return true;
        }
        if (BlockUtils.isLog(world, pos)) {
            TreeCache cache = new TreeCache(world, pos);
            cache.scanForTreeBlockSection();
            this.treeCache.put(pos, cache);
            return true;
        }
        return false;
    }

    @Override
    public List<ItemStack> doHarvestOperation(Level world, BlockPos pos, BlockState blockState) {
        return this.doHarvestOperation(world, pos, blockState, false);
    }

    @Override
    public List<ItemStack> doHarvestOperation(Level world, BlockPos pos, BlockState blockState, Object ... extras) {
        ArrayList<ItemStack> itemStacks = new ArrayList<ItemStack>();
        if (this.treeCache.containsKey(pos)) {
            TreeCache cache = this.treeCache.get(pos);
            if (cache.getWoodCache().isEmpty() && cache.getLeavesCache().isEmpty() && this.canBeHarvested(world, pos, blockState)) {
                cache.scanForTreeBlockSection();
            }
            int operations = 10;
            for (int i = 0; !(i >= operations || cache.getWoodCache().isEmpty() && cache.getLeavesCache().isEmpty()); ++i) {
                if (!cache.getLeavesCache().isEmpty()) {
                    itemStacks.addAll(cache.chop(cache.getLeavesCache(), (Boolean)extras[0]));
                    continue;
                }
                itemStacks.addAll(cache.chop(cache.getWoodCache(), (Boolean)extras[0]));
            }
            if (cache.getWoodCache().isEmpty() && cache.getLeavesCache().isEmpty()) {
                this.treeCache.remove(pos);
            }
        }
        return itemStacks;
    }

    @Override
    public boolean shouldCheckNextPlant(Level world, BlockPos pos, BlockState blockState) {
        return !this.canBeHarvested(world, pos, blockState);
    }

    @Override
    public List<String> getRecollectablesNames() {
        return Arrays.asList("text.industrialforegoing.plant.any_tree", "text.industrialforegoing.plant.slime_tree");
    }

    @Override
    public PlantRecollectable.Type getRecollectableType() {
        return PlantRecollectable.Type.TREE;
    }
}

