/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.resourceproduction.tile.ILaserBase;
import com.buuz135.industrial.block.tile.IndustrialMachineTile;
import com.buuz135.industrial.config.machine.resourceproduction.OreLaserBaseConfig;
import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.recipe.LaserDrillRarity;
import com.buuz135.industrial.utils.ItemStackUtils;
import com.buuz135.industrial.utils.ItemStackWeightedItem;
import com.hrznstudio.titanium.Titanium;
import com.hrznstudio.titanium._impl.TagConfig;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.api.IFactory;
import com.hrznstudio.titanium.api.augment.AugmentTypes;
import com.hrznstudio.titanium.api.augment.IAugmentType;
import com.hrznstudio.titanium.api.client.IScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.ProgressBarScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.client.screen.addon.WidgetScreenAddon;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.component.inventory.SidedInventoryComponent;
import com.hrznstudio.titanium.component.progress.ProgressBarComponent;
import com.hrznstudio.titanium.component.sideness.IFacingComponent;
import com.hrznstudio.titanium.item.AugmentWrapper;
import com.hrznstudio.titanium.network.Message;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import com.hrznstudio.titanium.network.locator.instance.TileEntityLocatorInstance;
import com.hrznstudio.titanium.network.messages.ButtonClickNetworkMessage;
import com.hrznstudio.titanium.util.RecipeUtil;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class OreLaserBaseTile
extends IndustrialMachineTile<OreLaserBaseTile>
implements ILaserBase<OreLaserBaseTile> {
    @Save
    private ProgressBarComponent<OreLaserBaseTile> work;
    @Save
    private SidedInventoryComponent<OreLaserBaseTile> lens;
    @Save
    private SidedInventoryComponent<OreLaserBaseTile> output;
    @Save
    private int miningDepth;

    public OreLaserBaseTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleResourceProduction.ORE_LASER_BASE, blockPos, blockState);
        this.setShowEnergy(false);
        this.miningDepth = this.getBlockPos().getY();
        this.work = new ProgressBarComponent<OreLaserBaseTile>(12, 22, 0, OreLaserBaseConfig.maxProgress){

            @OnlyIn(value=Dist.CLIENT)
            public List<IFactory<? extends IScreenAddon>> getScreenAddons() {
                return Collections.singletonList(() -> new ProgressBarScreenAddon<OreLaserBaseTile>(OreLaserBaseTile.this.work.getPosX(), OreLaserBaseTile.this.work.getPosY(), (ProgressBarComponent)this){

                    public List<Component> getTooltipLines() {
                        ArrayList<Component> tooltip = new ArrayList<Component>();
                        tooltip.add((Component)Component.literal((String)(String.valueOf(ChatFormatting.GOLD) + Component.translatable((String)"tooltip.titanium.progressbar.progress").getString() + String.valueOf(ChatFormatting.WHITE) + new DecimalFormat().format(OreLaserBaseTile.this.work.getProgress()) + String.valueOf(ChatFormatting.GOLD) + "/" + String.valueOf(ChatFormatting.WHITE) + new DecimalFormat().format(OreLaserBaseTile.this.work.getMaxProgress()))));
                        return tooltip;
                    }
                });
            }
        }.setColor(DyeColor.YELLOW).setCanIncrease(oreLaserBaseTile -> true).setProgressIncrease(0).setCanReset(oreLaserBaseTile -> true).setOnStart(() -> {
            int maxProgress = (int)Math.floor((float)OreLaserBaseConfig.maxProgress * (this.hasAugmentInstalled(AugmentTypes.EFFICIENCY) ? AugmentWrapper.getType((ItemStack)((ItemStack)this.getInstalledAugments(AugmentTypes.EFFICIENCY).get(0)), (IAugmentType)AugmentTypes.EFFICIENCY) : 1.0f));
            this.work.setMaxProgress(maxProgress);
        }).setOnFinishWork(this::onWork);
        this.addProgressBar(this.work);
        this.lens = (SidedInventoryComponent)new SidedInventoryComponent("lens", 30, 24, 6, 0).setColor(DyeColor.BLUE).setRange(2, 3).setSlotLimit(1);
        this.addInventory((InventoryComponent)this.lens);
        this.lens.getFacingModes().keySet().forEach(sideness -> this.lens.getFacingModes().put(sideness, IFacingComponent.FaceMode.NONE));
        this.output = (SidedInventoryComponent)new SidedInventoryComponent("output", 74, 24, 15, 1).setColor(DyeColor.ORANGE).setRange(5, 3).setInputFilter((stack, integer) -> false);
        this.addInventory((InventoryComponent)this.output);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        this.addGuiAddonFactory(() -> new TextScreenAddon(this, "", 70, 87, false){

            public String getText() {
                return String.valueOf(ChatFormatting.DARK_GRAY) + Component.translatable((String)"text.industrialforegoing.depth").getString();
            }
        });
        this.addGuiAddonFactory(() -> {
            EditBox edit = new EditBox(Minecraft.getInstance().font, 80, 26, 40, 12, (Component)Component.literal((String)("" + this.miningDepth))){

                public String getValue() {
                    return "" + OreLaserBaseTile.this.miningDepth;
                }
            };
            edit.setValue("" + this.miningDepth);
            edit.setFilter(string -> {
                if (string.isEmpty() || string.equals("-")) {
                    return true;
                }
                try {
                    Integer.decode(string);
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            });
            edit.setResponder(string -> {
                if (!string.isEmpty() && !string.equals("-")) {
                    CompoundTag compoundTag = new CompoundTag();
                    compoundTag.putInt("MiningLevel", Integer.decode(string).intValue());
                    Titanium.NETWORK.sendToServer((Message)new ButtonClickNetworkMessage((LocatorInstance)new TileEntityLocatorInstance(this.getBlockPos()), 5487, compoundTag));
                }
            });
            return new WidgetScreenAddon(102, 85, (AbstractWidget)edit);
        });
    }

    public void handleButtonMessage(int id, Player playerEntity, CompoundTag compound) {
        super.handleButtonMessage(id, playerEntity, compound);
        if (id == 5487) {
            this.miningDepth = compound.getInt("MiningLevel");
            this.syncObject(this.miningDepth);
        }
    }

    public void setChanged() {
        super.setChanged();
        if (this.miningDepth == -100) {
            this.miningDepth = this.worldPosition.getY();
        }
    }

    private void onWork() {
        List<ItemStackWeightedItem> items;
        if (!ItemStackUtils.isInventoryFull(this.output) && !(items = RecipeUtil.getRecipes((Level)this.level, (RecipeType)((RecipeType)ModuleCore.LASER_DRILL_TYPE.get())).stream().filter(laserDrillOreRecipe -> LaserDrillRarity.getValidRarity(this.level, laserDrillOreRecipe.rarity, this.level.dimensionType(), (Holder<Biome>)this.level.getBiome(this.worldPosition), this.miningDepth) != null).map(laserDrillOreRecipe -> {
            LaserDrillRarity rarity = LaserDrillRarity.getValidRarity(this.level, laserDrillOreRecipe.rarity, this.level.dimensionType(), (Holder<Biome>)this.level.getBiome(this.worldPosition), this.miningDepth);
            int weight = rarity.weight();
            for (int i = 0; i < this.lens.getSlots(); ++i) {
                if (!laserDrillOreRecipe.catalyst.test(this.lens.getStackInSlot(i))) continue;
                weight += OreLaserBaseConfig.catalystModifier;
            }
            ItemStack stack = ItemStack.EMPTY;
            for (String modid : TagConfig.ITEM_PREFERENCE) {
                for (ItemStack matchingStack : laserDrillOreRecipe.output.getItems()) {
                    if (!BuiltInRegistries.ITEM.getKey((Object)matchingStack.getItem()).getNamespace().equals(modid)) continue;
                    stack = matchingStack;
                    break;
                }
                if (stack.isEmpty()) continue;
                break;
            }
            if (stack.isEmpty()) {
                stack = laserDrillOreRecipe.output.getItems()[0];
            }
            return new ItemStackWeightedItem(stack.copy(), weight);
        }).toList()).isEmpty()) {
            ItemStack stack = ((ItemStackWeightedItem)WeightedRandom.getRandomItem((RandomSource)this.level.getRandom(), items).get()).getStack();
            ItemHandlerHelper.insertItem(this.output, (ItemStack)stack, (boolean)false);
        }
    }

    public OreLaserBaseTile getSelf() {
        return this;
    }

    protected EnergyStorageComponent<OreLaserBaseTile> createEnergyStorage() {
        return new EnergyStorageComponent(0, 4, 10);
    }

    @Override
    public ProgressBarComponent<OreLaserBaseTile> getBar() {
        return this.work;
    }

    @Override
    public boolean canAcceptAugment(ItemStack augment) {
        return AugmentWrapper.hasType((ItemStack)augment, (IAugmentType)AugmentTypes.EFFICIENCY);
    }

    @Override
    public void saveSettings(Player player, CompoundTag tag) {
        tag.putInt("OL_miningDepth", this.miningDepth);
        super.saveSettings(player, tag);
    }

    @Override
    public void loadSettings(Player player, CompoundTag tag) {
        if (tag.contains("OL_miningDepth")) {
            this.miningDepth = tag.getInt("OL_miningDepth");
        }
        super.loadSettings(player, tag);
    }
}

