/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.block.resourceproduction.tile;

import com.buuz135.industrial.block.tile.IndustrialAreaWorkingTile;
import com.buuz135.industrial.block.tile.IndustrialWorkingTile;
import com.buuz135.industrial.block.tile.RangeManager;
import com.buuz135.industrial.config.machine.resourceproduction.FluidPlacerConfig;
import com.buuz135.industrial.module.ModuleResourceProduction;
import com.buuz135.industrial.utils.BlockUtils;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.component.IComponentHarness;
import com.hrznstudio.titanium.component.energy.EnergyStorageComponent;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.component.fluid.SidedFluidTankComponent;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class FluidPlacerTile
extends IndustrialAreaWorkingTile<FluidPlacerTile> {
    private int getMaxProgress;
    private int getPowerPerOperation;
    @Save
    private SidedFluidTankComponent<FluidPlacerTile> tank = (SidedFluidTankComponent)new SidedFluidTankComponent("input", FluidPlacerConfig.maxInputTankSize, 43, 20, 0).setColor(DyeColor.BLUE).setTankAction(FluidTankComponent.Action.FILL).setComponentHarness((IComponentHarness)this);

    public FluidPlacerTile(BlockPos blockPos, BlockState blockState) {
        super(ModuleResourceProduction.FLUID_PLACER, RangeManager.RangeType.BEHIND, false, FluidPlacerConfig.powerPerOperation, blockPos, blockState);
        this.addTank(this.tank);
        this.getMaxProgress = FluidPlacerConfig.maxProgress;
        this.getPowerPerOperation = FluidPlacerConfig.powerPerOperation;
    }

    @Override
    public IndustrialWorkingTile.WorkAction work() {
        BlockPos pointed;
        if (this.hasEnergy(this.getPowerPerOperation) && this.isLoaded(pointed = this.getPointedBlockPos()) && BlockUtils.canBlockBeBroken(this.level, pointed, this.getUuid()) && !this.level.getFluidState(pointed).isSource() && this.tank.getFluidAmount() >= 1000) {
            if (this.tank.getFluid().getFluid().isSame((Fluid)Fluids.WATER) && this.level.getBlockState(pointed).hasProperty((Property)BlockStateProperties.WATERLOGGED) && !((Boolean)this.level.getBlockState(pointed).getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
                this.level.setBlockAndUpdate(pointed, (BlockState)this.level.getBlockState(pointed).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(true)));
                this.tank.drainForced(1000, IFluidHandler.FluidAction.EXECUTE);
                this.increasePointer();
                return new IndustrialWorkingTile.WorkAction(this, 1.0f, this.getPowerPerOperation);
            }
            if (this.level.isEmptyBlock(pointed) || !this.level.getFluidState(pointed).isEmpty() && !this.level.getFluidState(pointed).isSource()) {
                this.level.setBlockAndUpdate(pointed, this.tank.getFluid().getFluid().defaultFluidState().createLegacyBlock());
                this.tank.drainForced(1000, IFluidHandler.FluidAction.EXECUTE);
                this.increasePointer();
                return new IndustrialWorkingTile.WorkAction(this, 1.0f, this.getPowerPerOperation);
            }
        }
        this.increasePointer();
        return new IndustrialWorkingTile.WorkAction(this, 1.0f, 0);
    }

    protected EnergyStorageComponent<FluidPlacerTile> createEnergyStorage() {
        return new EnergyStorageComponent(FluidPlacerConfig.maxStoredPower, 10, 20);
    }

    @Override
    public int getMaxProgress() {
        return this.getMaxProgress;
    }

    @Nonnull
    public FluidPlacerTile getSelf() {
        return this;
    }
}

