/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.explosion;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.utils.explosion.ExplosionHelper;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.synth.SimplexNoise;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.fluids.IFluidBlock;
import org.joml.Vector3f;

public class ProcessExplosion {
    public final Vector3f origin;
    private final ServerLevel world;
    private final MinecraftServer server;
    private final int minimumDelay;
    public double[] angularResistance;
    public boolean isDead = false;
    public int radius = 0;
    public int maxRadius;
    public double circumference = 0.0;
    public double meanResistance = 0.0;
    public boolean lava = true;
    public HashSet<Long> blocksToUpdate = new HashSet();
    public LinkedList<HashSet<Long>> destroyedBlocks = new LinkedList();
    public HashSet<Long> lavaPositions = new HashSet();
    public HashSet<Long> destroyedCache = new HashSet();
    public HashSet<Long> scannedCache = new HashSet();
    public Consumer<Double> progressMon = null;
    protected boolean calculationComplete = false;
    protected boolean detonated = false;
    protected long startTime = -1L;
    protected long calcWait = 0L;
    private BlockState lavaState;

    public ProcessExplosion(BlockPos origin, int radius, ServerLevel world, int minimumDelayTime, String owner) {
        this.origin = new Vector3f((float)origin.getX(), (float)origin.getY(), (float)origin.getZ());
        this.world = world;
        this.server = world.getServer();
        this.minimumDelay = minimumDelayTime;
        this.angularResistance = new double[121];
        Arrays.fill(this.angularResistance, 100.0);
        IndustrialForegoing.LOGGER.info("Explosion Calculation Started for " + radius + " Block radius detonation! by " + owner);
        this.maxRadius = radius;
        this.lavaState = Blocks.LAVA.defaultBlockState();
    }

    public void updateProcess() {
        if (this.startTime == -1L) {
            this.startTime = System.currentTimeMillis();
        }
        if (this.calcWait > 0L) {
            --this.calcWait;
            return;
        }
        if (!this.calculationComplete) {
            long t = System.currentTimeMillis();
            this.updateCalculation();
            t = System.currentTimeMillis() - t;
            this.calcWait = t / 40L;
            IndustrialForegoing.LOGGER.debug("Calculation Progress: " + Mth.floor((double)((double)this.radius / (double)this.maxRadius * 100.0)) + "% " + Runtime.getRuntime().freeMemory() / 1000000L);
            if (this.calcWait > 0L) {
                IndustrialForegoing.LOGGER.debug("Explosion Calc loop took " + t + "ms! Waiting " + this.calcWait + " ticks before continuing");
            }
            if (this.progressMon != null) {
                this.progressMon.accept((double)this.radius / (double)this.maxRadius);
            }
        } else if (this.minimumDelay == -1) {
            this.isDead = true;
        } else if ((System.currentTimeMillis() - this.startTime) / 1000L >= (long)this.minimumDelay) {
            this.detonate();
        }
    }

    public void updateCalculation() {
        BlockPos originPos = new BlockPos((int)this.origin.x(), (int)this.origin.y(), (int)this.origin.z());
        double maxCoreHeight = 20.0 * ((double)this.maxRadius / 150.0);
        Vector3f posVecUp = new Vector3f();
        Vector3f posVecDown = new Vector3f();
        SimplexNoise noise = new SimplexNoise((RandomSource)new LegacyRandomSource(this.world.getSeed()));
        for (int x = originPos.getX() - this.radius; x < originPos.getX() + this.radius; ++x) {
            for (int z = originPos.getZ() - this.radius; z < originPos.getZ() + this.radius; ++z) {
                double dist = this.calculateDistanceBetweenPoints(x, z, originPos.getX(), originPos.getZ());
                if (!(dist < (double)this.radius) || !(dist >= (double)(this.radius - 1))) continue;
                posVecUp.set((float)x, this.origin.y(), (float)z);
                double radialAngle = this.getRadialAngle(posVecUp);
                double radialResistance = this.getRadialResistance(radialAngle);
                double angularLoad = this.meanResistance / radialResistance * 1.0;
                double radialPos = 1.0 - (double)this.radius / (double)this.maxRadius;
                double coreFalloff = Math.max(0.0, (radialPos - 0.8) * 5.0);
                coreFalloff = 1.0 - (1.0 - coreFalloff) * (1.0 - coreFalloff) * (1.0 - coreFalloff);
                double coreHeight = coreFalloff * maxCoreHeight;
                double edgeNoise = Math.max(0.0, (-radialPos + 0.2) * 5.0);
                double edgeScatter = edgeNoise * (double)this.world.getRandom().nextInt(10);
                double sim = noise.getValue((double)x / 50.0, (double)z / 50.0);
                edgeNoise = 1.0 + Math.abs(sim) * edgeNoise * 8.0;
                double power = 10000.0 * radialPos * radialPos * radialPos * angularLoad * edgeNoise + edgeScatter;
                double heightUp = 20.0 + (5.0 + (double)this.radius / 10.0) * angularLoad;
                double heightDown = coreHeight + (5.0 + (double)this.radius / 10.0) * angularLoad * (1.0 - coreFalloff);
                heightDown += Math.abs(sim) * 4.0 + this.world.getRandom().nextDouble();
                posVecDown.set(posVecUp.x(), posVecUp.y(), posVecUp.z());
                double resist = this.trace(posVecUp, power * (1.0 + 8.0 * radialPos), (int)(heightUp += Math.abs(sim) * 4.0 + this.world.getRandom().nextDouble()) * 3, 1, 0.0, 0);
                posVecDown.set(posVecDown.x(), posVecDown.y() - 1.0f, posVecDown.z());
                resist += this.trace(posVecDown, power, (int)heightDown, -1, 0.0, 0);
                resist *= 1.0 / angularLoad;
                if (!(radialPos < 0.8)) continue;
                this.addRadialResistance(radialAngle, resist);
            }
        }
        this.recalcResist();
        ++this.radius;
        this.circumference = Math.PI * 2 * (double)this.radius;
        this.destroyedBlocks.add(this.destroyedCache);
        this.destroyedCache = new HashSet();
        this.scannedCache = new HashSet();
        if (this.radius >= this.maxRadius) {
            IndustrialForegoing.LOGGER.info("Explosion Calculation Completed in " + (System.currentTimeMillis() - this.startTime) / 1000L + "s");
            this.calculationComplete = true;
        }
    }

    public double calculateDistanceBetweenPoints(double x1, double y1, double x2, double y2) {
        return Math.sqrt((y2 - y1) * (y2 - y1) + (x2 - x1) * (x2 - x1));
    }

    private void recalcResist() {
        double total = 0.0;
        for (double resist : this.angularResistance) {
            total += resist;
        }
        this.meanResistance = total / (double)this.angularResistance.length;
    }

    public double getRadialAngle(Vector3f pos) {
        double theta = Math.atan2(pos.x() - this.origin.x(), this.origin.z() - pos.z());
        if (theta < 0.0) {
            theta += Math.PI * 2;
        }
        return theta / (Math.PI * 2) * (double)this.angularResistance.length;
    }

    public double getRadialResistance(double radialPos) {
        int max;
        int min = Mth.floor((double)radialPos);
        if (min >= this.angularResistance.length) {
            min -= this.angularResistance.length;
        }
        if ((max = Mth.ceil((double)radialPos)) >= this.angularResistance.length) {
            max -= this.angularResistance.length;
        }
        double delta = radialPos - (double)min;
        return this.angularResistance[min] * (1.0 - delta) + this.angularResistance[max] * delta;
    }

    public void addRadialResistance(double radialPos, double power) {
        int max;
        int min = Mth.floor((double)radialPos);
        if (min >= this.angularResistance.length) {
            min -= this.angularResistance.length;
        }
        if ((max = Mth.ceil((double)radialPos)) >= this.angularResistance.length) {
            max -= this.angularResistance.length;
        }
        double delta = radialPos - (double)min;
        int n = min;
        this.angularResistance[n] = this.angularResistance[n] + power * (1.0 - delta);
        int n2 = max;
        this.angularResistance[n2] = this.angularResistance[n2] + power * delta;
    }

    private double trace(Vector3f posVec, double power, int dist, int traceDir, double totalResist, int travel) {
        if (dist > 100) {
            dist = 100;
        }
        if (dist <= 0 || power <= 0.0 || posVec.y() < (float)this.world.getMinBuildHeight() || posVec.y() > (float)this.world.getMaxBuildHeight()) {
            return totalResist;
        }
        --dist;
        ++travel;
        long iPos = new BlockPos((int)posVec.x(), (int)posVec.y(), (int)posVec.z()).asLong();
        if (this.scannedCache.contains(iPos) || this.destroyedCache.contains(iPos)) {
            posVec.set(posVec.x(), posVec.y() + (float)traceDir, posVec.z());
            return this.trace(posVec, power, dist, traceDir, totalResist, travel);
        }
        BlockPos pos = new BlockPos((int)posVec.x(), (int)posVec.y(), (int)posVec.z());
        double r = 1.0;
        BlockState state = this.world.getBlockState(pos);
        Block block = state.getBlock();
        if (!state.isAir()) {
            double effectivePower = power / 10.0 * ((double)dist / (double)(dist + travel));
            r = block.getExplosionResistance();
            if (effectivePower >= r) {
                this.destroyedCache.add(iPos);
            } else if (block.equals(Blocks.WATER) || block.equals(Blocks.LAVA)) {
                if (effectivePower > 5.0) {
                    this.destroyedCache.add(iPos);
                } else {
                    this.blocksToUpdate.add(iPos);
                }
                r = 10.0;
            } else {
                if (block instanceof IFluidBlock || block instanceof FallingBlock) {
                    this.blocksToUpdate.add(iPos);
                }
                this.scannedCache.add(iPos);
            }
            if (r > 1000.0) {
                r = 1000.0;
            }
        } else {
            this.scannedCache.add(iPos);
        }
        r = r / (double)this.radius / (double)travel;
        totalResist += r;
        power -= r;
        if (dist == 1 && traceDir == -1 && this.lava && this.world.getRandom().nextInt(250) == 0 && !this.world.isEmptyBlock(pos.below())) {
            dist = 0;
            if (this.destroyedCache.contains(iPos)) {
                this.destroyedCache.remove(iPos);
            }
            this.lavaPositions.add(iPos);
            this.blocksToUpdate.add(iPos);
            this.scannedCache.add(iPos);
        }
        posVec.set(posVec.x(), posVec.y() + (float)traceDir, posVec.z());
        return this.trace(posVec, power, dist, traceDir, totalResist, travel);
    }

    public boolean isCalculationComplete() {
        return this.calculationComplete;
    }

    public boolean detonate() {
        if (!this.isCalculationComplete() || this.detonated) {
            return false;
        }
        long l = System.currentTimeMillis();
        IndustrialForegoing.LOGGER.debug("Removing Blocks!");
        BlockPos pos = new BlockPos((int)this.origin.x(), (int)this.origin.y(), (int)this.origin.z());
        new Thread(() -> {
            List list = this.world.getEntitiesOfClass(Entity.class, new AABB(pos, pos.offset(1, 1, 1)).inflate((double)this.radius * 2.5, (double)this.radius * 2.5, (double)this.radius * 2.5));
            for (Entity e : list) {
                if (e instanceof Cat) continue;
                float dmg = 10000.0f;
                if (e instanceof Player) {
                    for (int i = 0; i < 100; ++i) {
                        e.hurt(e.level().damageSources().genericKill(), 100.0f);
                    }
                    continue;
                }
                e.hurt(e.level().damageSources().genericKill(), dmg);
            }
        }).start();
        ExplosionHelper removalHelper = new ExplosionHelper(this.world, new BlockPos((int)this.origin.x(), (int)this.origin.y(), (int)this.origin.z()));
        int i = 0;
        removalHelper.setBlocksForRemoval(this.destroyedBlocks);
        for (long posI : this.lavaPositions) {
            this.world.setBlockAndUpdate(BlockPos.of((long)posI), this.lavaState);
        }
        removalHelper.addBlocksForUpdate(this.blocksToUpdate);
        IndustrialForegoing.LOGGER.debug("Blocks Removed: " + i);
        removalHelper.finish();
        this.isDead = true;
        this.detonated = true;
        IndustrialForegoing.LOGGER.debug("Total explosion time: " + (double)(System.currentTimeMillis() - l) / 1000.0 + "s");
        return true;
    }

    public boolean isDead() {
        return this.isDead;
    }
}

