/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils.apihandlers.plant;

import com.buuz135.industrial.utils.BlockUtils;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Stack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.IForgeShearable;

public class TreeCache {
    private Queue<BlockPos> woodCache = new PriorityQueue<Object>(Comparator.comparingDouble(value -> ((BlockPos)value).distSqr(new Vec3i(((BlockPos)value).getX(), current.getY(), ((BlockPos)value).getZ()))).reversed());
    private Queue<BlockPos> leavesCache = new PriorityQueue<Object>(Comparator.comparingDouble(value -> ((BlockPos)value).distSqr(new Vec3i(current.getX(), ((BlockPos)value).getY(), current.getZ()))).reversed());
    private Level world;
    private BlockPos current;

    public TreeCache(Level world, BlockPos current) {
        this.world = world;
        this.current = current;
    }

    public List<ItemStack> chop(Queue<BlockPos> cache, boolean shear) {
        BlockPos p = cache.peek();
        NonNullList stacks = NonNullList.create();
        if (BlockUtils.isLeaves(this.world, p) || BlockUtils.isLog(this.world, p)) {
            BlockState s = this.world.getBlockState(p);
            if (s.getBlock() instanceof IForgeShearable && shear) {
                stacks.addAll((Collection)((IForgeShearable)s.getBlock()).onSheared(null, new ItemStack((ItemLike)Items.SHEARS), this.world, p, 0));
            } else {
                stacks.addAll(BlockUtils.getBlockDrops(this.world, p));
            }
            this.world.setBlockAndUpdate(p, Blocks.AIR.defaultBlockState());
        }
        cache.poll();
        return stacks;
    }

    public Queue<BlockPos> getWoodCache() {
        return this.woodCache;
    }

    public Queue<BlockPos> getLeavesCache() {
        return this.leavesCache;
    }

    public void scanForTreeBlockSection() {
        BlockPos yCheck = this.getHighestBlock(this.current);
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)yCheck.offset(1, 0, 0), (BlockPos)yCheck.offset(0, 0, 1))) {
            BlockPos tempHigh = this.getHighestBlock(pos.immutable());
            if (tempHigh.getY() <= yCheck.getY()) continue;
            yCheck = tempHigh;
        }
        yCheck = yCheck.offset(0, -Math.min(20, yCheck.getY() - this.current.getY()), 0);
        HashSet<BlockPos> checkedPositions = new HashSet<BlockPos>();
        Stack<BlockPos> tree = new Stack<BlockPos>();
        BlockPos test = new BlockPos(this.current.getX(), yCheck.getY(), this.current.getZ());
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)test.offset(1, 0, 0), (BlockPos)test.offset(0, 0, 1))) {
            tree.push(pos.immutable());
        }
        while (!tree.isEmpty()) {
            BlockPos checking = (BlockPos)tree.pop();
            if (!BlockUtils.isLeaves(this.world, checking) && !BlockUtils.isLog(this.world, checking)) continue;
            for (BlockPos pos : BlockPos.betweenClosed((BlockPos)checking.offset(-1, 0, -1), (BlockPos)checking.offset(1, 1, 1))) {
                BlockPos blockPos = pos.immutable();
                if (this.world.isEmptyBlock(blockPos) || checkedPositions.contains(blockPos) || blockPos.distManhattan(new Vec3i(this.current.getX(), this.current.getY(), this.current.getZ())) > 100) continue;
                if (BlockUtils.isLeaves(this.world, blockPos)) {
                    tree.push(blockPos);
                    this.leavesCache.add(blockPos);
                    checkedPositions.add(blockPos);
                    continue;
                }
                if (!BlockUtils.isLog(this.world, blockPos)) continue;
                tree.push(blockPos);
                this.woodCache.add(blockPos);
                checkedPositions.add(blockPos);
            }
        }
    }

    public BlockPos getHighestBlock(BlockPos position) {
        while (!this.world.isEmptyBlock(position.above()) && (BlockUtils.isLog(this.world, position.above()) || BlockUtils.isLeaves(this.world, position.above()))) {
            position = position.above();
        }
        return position;
    }
}

