/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.utils;

import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.CrusherRecipe;
import com.hrznstudio.titanium.util.RecipeUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class CraftingUtils {
    public static Set<ItemStack[]> missingRecipes = new HashSet<ItemStack[]>();
    private static HashMap<ItemStack, ItemStack> cachedRecipes = new HashMap();

    public static ItemStack findOutput(int size, ItemStack input, Level world) {
        if (input.getCount() < size * size) {
            return ItemStack.EMPTY;
        }
        ItemStack cachedStack = input.copy();
        cachedStack.setCount(size * size);
        for (Map.Entry<ItemStack, ItemStack> entry : cachedRecipes.entrySet()) {
            if (!ItemStack.isSameItem((ItemStack)entry.getValue(), (ItemStack)cachedStack) || entry.getKey().getCount() != cachedStack.getCount()) continue;
            return entry.getValue().copy();
        }
        TransientCraftingContainer inventoryCrafting = new TransientCraftingContainer(new AbstractContainerMenu(null, 0){

            public ItemStack quickMoveStack(Player p_38941_, int p_38942_) {
                return ItemStack.EMPTY;
            }

            public boolean stillValid(Player playerIn) {
                return false;
            }
        }, size, size);
        for (int i = 0; i < size * size; ++i) {
            inventoryCrafting.setItem(i, input.copy());
        }
        CraftingRecipe recipe = world.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (Container)inventoryCrafting, world).orElse(null);
        if (recipe != null) {
            ItemStack output = recipe.getResultItem(world.registryAccess());
            cachedRecipes.put(cachedStack, output.copy());
            return output.copy();
        }
        return ItemStack.EMPTY;
    }

    public static CraftingContainer genCraftingInventory(Level world, ItemStack ... inputs) {
        TransientCraftingContainer inventoryCrafting = new TransientCraftingContainer(new AbstractContainerMenu(null, 0){

            public boolean stillValid(Player playerIn) {
                return false;
            }

            public ItemStack quickMoveStack(Player p_38941_, int p_38942_) {
                return ItemStack.EMPTY;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            inventoryCrafting.setItem(i, inputs[i]);
        }
        return inventoryCrafting;
    }

    public static Recipe findRecipe(Level world, ItemStack ... inputs) {
        for (ItemStack[] missingRecipe : missingRecipes) {
            if (!CraftingUtils.doesStackArrayEquals(missingRecipe, inputs)) continue;
            return null;
        }
        Recipe recipe = (Recipe)world.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (Container)CraftingUtils.genCraftingInventory(world, inputs), world).orElseGet(null);
        if (recipe == null) {
            missingRecipes.add(inputs);
        }
        return recipe;
    }

    public static boolean doesStackArrayEquals(ItemStack[] original, ItemStack[] compare) {
        if (original.length != compare.length) {
            return false;
        }
        for (int i = 0; i < original.length; ++i) {
            if (original[i].isEmpty() && compare[i].isEmpty() || ItemStack.isSameItem((ItemStack)original[i], (ItemStack)compare[i])) continue;
            return false;
        }
        return true;
    }

    public static ItemStack getCrushOutput(Level world, ItemStack stack) {
        for (CrusherRecipe recipe : RecipeUtil.getRecipes((Level)world, (RecipeType)((RecipeType)ModuleCore.CRUSHER_TYPE.get()))) {
            if (!recipe.input.test(stack)) continue;
            return recipe.output.getItems()[0];
        }
        return ItemStack.EMPTY;
    }
}

