/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.recipe;

import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.recipe.LaserDrillRarity;
import com.hrznstudio.titanium.recipe.serializer.GenericSerializer;
import com.hrznstudio.titanium.recipe.serializer.SerializableRecipe;
import com.hrznstudio.titanium.util.TagUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import org.apache.commons.lang3.tuple.Pair;

public class LaserDrillOreRecipe
extends SerializableRecipe {
    public static List<LaserDrillOreRecipe> RECIPES = new ArrayList<LaserDrillOreRecipe>();
    public Ingredient output;
    public LaserDrillRarity[] rarity;
    public int pointer = 0;
    public Ingredient catalyst;
    private ResourceLocation isTag;

    public static void init() {
        LaserDrillOreRecipe.createWithDefault("coal", (ItemLike)Blocks.COAL_ORE, 15, 5, 132, 10, 4);
        LaserDrillOreRecipe.createWithDefault("raw_materials/iron", 12, 5, 68, 20, 3);
        LaserDrillOreRecipe.createWithDefault("redstone", (ItemLike)Blocks.REDSTONE_ORE, 14, 5, 16, 28, 4);
        new LaserDrillOreRecipe("raw_materials/gold", Ingredient.of((TagKey)TagUtil.getItemTag((ResourceLocation)new ResourceLocation("forge", "raw_materials/gold"))), 4, null, new LaserDrillRarity(new ResourceKey[]{Biomes.BADLANDS, Biomes.ERODED_BADLANDS}, new ResourceKey[0], 32, 80, 16), new LaserDrillRarity(new ResourceKey[0], LaserDrillRarity.END, 5, 32, 6), new LaserDrillRarity(new ResourceKey[0], LaserDrillRarity.END, 0, 255, 1));
        LaserDrillOreRecipe.createWithDefault("lapis", (ItemLike)Blocks.LAPIS_ORE, 11, 13, 34, 14, 2);
        new LaserDrillOreRecipe("emerald", Ingredient.of((ItemLike[])new ItemLike[]{Blocks.EMERALD_ORE}), 5, null, new LaserDrillRarity(new ResourceKey[]{Biomes.WINDSWEPT_GRAVELLY_HILLS, Biomes.WINDSWEPT_GRAVELLY_HILLS}, new ResourceKey[0], 5, 29, 8), new LaserDrillRarity(new ResourceKey[0], LaserDrillRarity.END, 0, 255, 1));
        LaserDrillOreRecipe.createWithDefault("diamond", (ItemLike)Blocks.DIAMOND_ORE, 3, 5, 16, 4, 1);
        new LaserDrillOreRecipe("quartz", Ingredient.of((ItemLike[])new ItemLike[]{Blocks.NETHER_QUARTZ_ORE}), 0, null, new LaserDrillRarity(LaserDrillRarity.NETHER, new ResourceKey[0], 7, 117, 12), new LaserDrillRarity(new ResourceKey[0], LaserDrillRarity.END, 0, 255, 1));
        new LaserDrillOreRecipe("glowstone", Ingredient.of((ItemLike[])new ItemLike[]{Blocks.GLOWSTONE}), 4, null, new LaserDrillRarity(LaserDrillRarity.NETHER, new ResourceKey[0], 7, 117, 8), new LaserDrillRarity(new ResourceKey[0], LaserDrillRarity.END, 0, 255, 1));
        new LaserDrillOreRecipe("raw_materials/uranium", Ingredient.of((TagKey)TagUtil.getItemTag((ResourceLocation)new ResourceLocation("forge", "raw_materials/uranium"))), 5, new ResourceLocation("forge", "raw_materials/uranium"), new LaserDrillRarity(LaserDrillRarity.NETHER, new ResourceKey[0], 5, 29, 5), new LaserDrillRarity(new ResourceKey[0], LaserDrillRarity.END, 0, 255, 1));
        LaserDrillOreRecipe.createWithDefault("ores/sulfur", 4, 5, 10, 6, 1);
        LaserDrillOreRecipe.createWithDefault("raw_materials/galena", 10, 15, 30, 6, 1);
        new LaserDrillOreRecipe("raw_materials/iridium", Ingredient.of((TagKey)TagUtil.getItemTag((ResourceLocation)new ResourceLocation("forge", "raw_materials/iridium"))), 0, new ResourceLocation("forge", "raw_materials/iridium"), new LaserDrillRarity(LaserDrillRarity.END, new ResourceKey[0], 5, 68, 8), new LaserDrillRarity(new ResourceKey[0], LaserDrillRarity.END, 0, 255, 1));
        LaserDrillOreRecipe.createWithDefault("ores/ruby", 14, 30, 70, 6, 1);
        LaserDrillOreRecipe.createWithDefault("ores/sapphire", 11, 30, 70, 6, 1);
        LaserDrillOreRecipe.createWithDefault("ores/peridot", 13, 30, 70, 6, 1);
        LaserDrillOreRecipe.createWithDefault("ores/sodalite", 11, 30, 70, 6, 1);
        LaserDrillOreRecipe.createWithDefault("ores/yellorite", 4, 16, 68, 3, 1);
        LaserDrillOreRecipe.createWithDefault("ores/cinnabar", 14, 30, 70, 2, 1);
        LaserDrillOreRecipe.createWithDefault("raw_materials/bauxite", 12, 50, 100, 6, 1);
        LaserDrillOreRecipe.createWithDefault("raw_materials/pyrite", 12, 30, 70, 3, 1);
        LaserDrillOreRecipe.createWithDefault("raw_materials/cinnabar", 14, 30, 70, 2, 1);
        LaserDrillOreRecipe.createEnd("raw_materials/tungsten", 15, 20, 70, 4);
        LaserDrillOreRecipe.createEnd("raw_materials/sheldonite", 0, 30, 70, 6);
        LaserDrillOreRecipe.createWithDefault("raw_materials/platinum", 3, 5, 16, 3, 1);
        LaserDrillOreRecipe.createWithDefault("raw_materials/tetrahedrite", 14, 60, 90, 4, 1);
        LaserDrillOreRecipe.createWithDefault("raw_materials/tin", 8, 64, 96, 8, 2);
        LaserDrillOreRecipe.createWithDefault("raw_materials/lead", 10, 10, 40, 6, 1);
        LaserDrillOreRecipe.createWithDefault("raw_materials/silver", 7, 10, 40, 5, 1);
        LaserDrillOreRecipe.createWithDefault("raw_materials/copper", 1, 35, 65, 10, 2);
        LaserDrillOreRecipe.createWithDefault("raw_materials/aluminum", 12, 68, 84, 5, 1);
        LaserDrillOreRecipe.createWithDefault("raw_materials/nickel", 12, 5, 68, 4, 1);
        LaserDrillOreRecipe.createEnd("ores/draconium", 10, 60, 95, 10);
        LaserDrillOreRecipe.createWithDefault("raw_materials/yellorium", 4, 16, 68, 3, 1);
        LaserDrillOreRecipe.createNether("raw_materials/cobalt", 11, 34, 96, 8);
        LaserDrillOreRecipe.createNether("raw_materials/ardite", 4, 89, 116, 8);
        new LaserDrillOreRecipe("ancient_debris", Ingredient.of((ItemLike[])new ItemLike[]{Blocks.ANCIENT_DEBRIS}), 12, null, new LaserDrillRarity(LaserDrillRarity.NETHER, new ResourceKey[0], 1, 20, 1));
        LaserDrillOreRecipe.createWithDefault("ores/niter", 4, 5, 20, 2, 1);
        LaserDrillOreRecipe.createWithDefault("ores/arcane", 2, 45, 60, 3, 1);
        LaserDrillOreRecipe.createWithDefault("ores/bitumen", 15, 50, 60, 2, 1);
        LaserDrillOreRecipe.createWithDefault("ores/fluorite", 8, 15, 30, 6, 1);
        LaserDrillOreRecipe.createWithDefault("raw_materials/osmium", 8, 5, 36, 8, 1);
        LaserDrillOreRecipe.createWithDefault("raw_materials/yellorite", 4, 15, 50, 3, 1);
    }

    public static LaserDrillOreRecipe createWithDefault(String name, ItemLike output, int color, int min, int max, int weight, int defaultWeight) {
        return LaserDrillOreRecipe.createWithDefault(name, Ingredient.of((ItemLike[])new ItemLike[]{output}), color, min, max, weight, defaultWeight, null);
    }

    public static LaserDrillOreRecipe createWithDefault(String name, int color, int min, int max, int weight, int defaultWeight) {
        ResourceLocation rl = new ResourceLocation("forge", name);
        return LaserDrillOreRecipe.createWithDefault(name, Ingredient.of((TagKey)TagUtil.getItemTag((ResourceLocation)rl)), color, min, max, weight, defaultWeight, rl);
    }

    public static LaserDrillOreRecipe createWithDefault(String name, Ingredient output, int color, int min, int max, int weight, int defaultWeight, ResourceLocation isTag) {
        return new LaserDrillOreRecipe(name, output, color, isTag, new LaserDrillRarity(new ResourceKey[0], LaserDrillRarity.END, min, max, weight), new LaserDrillRarity(new ResourceKey[0], LaserDrillRarity.END, 0, 255, defaultWeight));
    }

    public static LaserDrillOreRecipe createEnd(String name, int color, int min, int max, int weight) {
        ResourceLocation rl = new ResourceLocation("forge", name);
        return LaserDrillOreRecipe.createEnd(name, Ingredient.of((TagKey)TagUtil.getItemTag((ResourceLocation)rl)), color, min, max, weight, rl);
    }

    public static LaserDrillOreRecipe createEnd(String name, Ingredient output, int color, int min, int max, int weight, ResourceLocation isTag) {
        return new LaserDrillOreRecipe(name, output, color, isTag, new LaserDrillRarity(LaserDrillRarity.END, new ResourceKey[0], min, max, weight));
    }

    public static LaserDrillOreRecipe createNether(String name, int color, int min, int max, int weight) {
        ResourceLocation rl = new ResourceLocation("forge", "ores/" + name);
        return LaserDrillOreRecipe.createNether(name, Ingredient.of((TagKey)TagUtil.getItemTag((ResourceLocation)rl)), color, min, max, weight, rl);
    }

    public static LaserDrillOreRecipe createNether(String name, Ingredient output, int color, int min, int max, int weight, ResourceLocation isTag) {
        return new LaserDrillOreRecipe(name, output, color, isTag, new LaserDrillRarity(LaserDrillRarity.NETHER, new ResourceKey[0], min, max, weight));
    }

    public LaserDrillOreRecipe(String name, Ingredient output, Ingredient catalyst, ResourceLocation isTag, LaserDrillRarity ... rarity) {
        super(new ResourceLocation("industrialforegoing", name));
        this.output = output;
        this.catalyst = catalyst;
        this.rarity = rarity;
        this.isTag = isTag;
        RECIPES.add(this);
    }

    public LaserDrillOreRecipe(String name, Ingredient output, int color, ResourceLocation isTag, LaserDrillRarity ... rarity) {
        this(name, output, Ingredient.of((ItemLike[])new ItemLike[]{(ItemLike)ModuleCore.LASER_LENS[color].get()}), isTag, rarity);
    }

    public LaserDrillOreRecipe(ResourceLocation resourceLocation) {
        super(resourceLocation);
    }

    public boolean matches(Container inv, Level worldIn) {
        return false;
    }

    public ItemStack assemble(Container inv, RegistryAccess access) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(RegistryAccess access) {
        return ItemStack.EMPTY;
    }

    public GenericSerializer<? extends SerializableRecipe> getSerializer() {
        return (GenericSerializer)ModuleCore.LASER_DRILL_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModuleCore.LASER_DRILL_TYPE.get();
    }

    public Pair<ICondition, IConditionSerializer> getOutputCondition() {
        if (this.isTag != null) {
            return Pair.of((Object)new NotCondition((ICondition)new TagEmptyCondition(this.isTag)), (Object)NotCondition.Serializer.INSTANCE);
        }
        return null;
    }

    @Nullable
    public LaserDrillRarity getValidRarity(ResourceLocation biome, int height) {
        for (LaserDrillRarity laserDrillRarity : this.rarity) {
            if (laserDrillRarity.depth_max < height || laserDrillRarity.depth_min > height || !(laserDrillRarity.whitelist.length == 0 ? Arrays.stream(laserDrillRarity.blacklist).noneMatch(registryKey -> registryKey.location().equals((Object)biome)) : Arrays.stream(laserDrillRarity.whitelist).anyMatch(registryKey -> registryKey.location().equals((Object)biome)))) continue;
            return laserDrillRarity;
        }
        return null;
    }
}

