/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.recipe;

import com.buuz135.industrial.module.ModuleCore;
import com.hrznstudio.titanium.recipe.serializer.GenericSerializer;
import com.hrznstudio.titanium.recipe.serializer.SerializableRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class FluidExtractorRecipe
extends SerializableRecipe {
    public static List<FluidExtractorRecipe> RECIPES = new ArrayList<FluidExtractorRecipe>();
    public Ingredient.Value input;
    public Block result;
    public float breakChance;
    public FluidStack output;
    public boolean defaultRecipe;
    private transient Ingredient ingredient;

    public FluidExtractorRecipe(ResourceLocation resourceLocation) {
        super(resourceLocation);
    }

    public FluidExtractorRecipe(ResourceLocation resourceLocation, Ingredient.Value input, Block result, float breakChance, FluidStack output, boolean defaultRecipe) {
        super(resourceLocation);
        this.input = input;
        this.result = result;
        this.breakChance = breakChance;
        this.output = output;
        this.defaultRecipe = defaultRecipe;
        RECIPES.add(this);
    }

    public boolean matches(Level world, BlockPos pos) {
        return this.getOrCacheInput().test(new ItemStack((ItemLike)world.getBlockState(pos).getBlock()));
    }

    public boolean matches(Container inv, Level worldIn) {
        return false;
    }

    public ItemStack assemble(Container inv, RegistryAccess access) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return false;
    }

    public ItemStack getResultItem(RegistryAccess registryAccess) {
        return (ItemStack)this.input.getItems().iterator().next();
    }

    public GenericSerializer<? extends SerializableRecipe> getSerializer() {
        return (GenericSerializer)ModuleCore.FLUID_EXTRACTOR_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)ModuleCore.FLUID_EXTRACTOR_TYPE.get();
    }

    private Ingredient getOrCacheInput() {
        if (this.ingredient == null) {
            this.ingredient = Ingredient.fromValues(Stream.of(this.input));
        }
        return this.ingredient;
    }

    static {
        new FluidExtractorRecipe(new ResourceLocation("industrialforegoing", "acacia"), (Ingredient.Value)new Ingredient.ItemValue(new ItemStack((ItemLike)Blocks.ACACIA_LOG)), Blocks.STRIPPED_ACACIA_LOG, 0.01f, new FluidStack((Fluid)ModuleCore.LATEX.getSourceFluid().get(), 4), false);
        new FluidExtractorRecipe(new ResourceLocation("industrialforegoing", "dark_oak"), (Ingredient.Value)new Ingredient.ItemValue(new ItemStack((ItemLike)Blocks.DARK_OAK_LOG)), Blocks.STRIPPED_DARK_OAK_LOG, 0.01f, new FluidStack((Fluid)ModuleCore.LATEX.getSourceFluid().get(), 3), false);
        new FluidExtractorRecipe(new ResourceLocation("industrialforegoing", "oak"), (Ingredient.Value)new Ingredient.ItemValue(new ItemStack((ItemLike)Blocks.OAK_LOG)), Blocks.STRIPPED_OAK_LOG, 0.01f, new FluidStack((Fluid)ModuleCore.LATEX.getSourceFluid().get(), 2), false);
        new FluidExtractorRecipe(new ResourceLocation("industrialforegoing", "spruce"), (Ingredient.Value)new Ingredient.ItemValue(new ItemStack((ItemLike)Blocks.SPRUCE_LOG)), Blocks.STRIPPED_SPRUCE_LOG, 0.01f, new FluidStack((Fluid)ModuleCore.LATEX.getSourceFluid().get(), 2), false);
        new FluidExtractorRecipe(new ResourceLocation("industrialforegoing", "birch"), (Ingredient.Value)new Ingredient.ItemValue(new ItemStack((ItemLike)Blocks.BIRCH_LOG)), Blocks.STRIPPED_BIRCH_LOG, 0.01f, new FluidStack((Fluid)ModuleCore.LATEX.getSourceFluid().get(), 2), false);
        new FluidExtractorRecipe(new ResourceLocation("industrialforegoing", "jungle"), (Ingredient.Value)new Ingredient.ItemValue(new ItemStack((ItemLike)Blocks.JUNGLE_LOG)), Blocks.STRIPPED_JUNGLE_LOG, 0.01f, new FluidStack((Fluid)ModuleCore.LATEX.getSourceFluid().get(), 2), false);
        new FluidExtractorRecipe(new ResourceLocation("industrialforegoing", "default"), (Ingredient.Value)new Ingredient.TagValue(ItemTags.LOGS), Blocks.AIR, 0.01f, new FluidStack((Fluid)ModuleCore.LATEX.getSourceFluid().get(), 1), true);
    }
}

