/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.network;

import com.buuz135.industrial.IndustrialForegoing;
import com.buuz135.industrial.item.infinity.item.ItemInfinityBackpack;
import com.buuz135.industrial.module.ModuleTool;
import com.buuz135.industrial.proxy.network.BackpackOpenedMessage;
import com.buuz135.industrial.worlddata.BackpackDataManager;
import com.hrznstudio.titanium.network.Message;
import com.hrznstudio.titanium.network.locator.LocatorFactory;
import com.hrznstudio.titanium.network.locator.LocatorInstance;
import com.hrznstudio.titanium.network.locator.instance.InventoryStackLocatorInstance;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;

public class BackpackOpenMessage
extends Message {
    private boolean forceDisable;

    public BackpackOpenMessage(boolean forceDisable) {
        this.forceDisable = forceDisable;
    }

    public BackpackOpenMessage() {
    }

    protected void handleMessage(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            ServerPlayer entity = context.getSender();
            ItemInfinityBackpack.findFirstBackpack((Player)entity).ifPresent(target -> {
                ItemStack stack = (ItemStack)target.getFinder().getStackGetter().apply(entity, target.getSlot());
                if (stack.getItem() instanceof ItemInfinityBackpack) {
                    Object id;
                    if (!stack.hasTag() || !stack.getTag().contains("Id")) {
                        id = UUID.randomUUID();
                        CompoundTag nbt = stack.getOrCreateTag();
                        nbt.putString("Id", ((UUID)id).toString());
                        BackpackDataManager.getData((LevelAccessor)entity.level()).createBackPack((UUID)id);
                        stack.setTag(nbt);
                    }
                    id = stack.getTag().getString("Id");
                    if (this.forceDisable) {
                        ItemInfinityBackpack.setPickUpMode(stack, 3);
                        entity.displayClientMessage((Component)Component.translatable((String)"tooltip.industrialforegoing.backpack.pickup_disabled").withStyle(ChatFormatting.RED), true);
                    } else if (entity.isShiftKeyDown()) {
                        int mode = (ItemInfinityBackpack.getPickUpMode(stack) + 1) % 4;
                        ItemInfinityBackpack.setPickUpMode(stack, mode);
                        switch (mode) {
                            case 0: {
                                entity.displayClientMessage((Component)Component.translatable((String)"tooltip.industrialforegoing.backpack.pickup_all").withStyle(ChatFormatting.GREEN), true);
                                return;
                            }
                            case 1: {
                                entity.displayClientMessage((Component)Component.translatable((String)"tooltip.industrialforegoing.backpack.item_pickup_enabled").withStyle(ChatFormatting.GREEN), true);
                                return;
                            }
                            case 2: {
                                entity.displayClientMessage((Component)Component.translatable((String)"tooltip.industrialforegoing.backpack.xp_pickup_enabled").withStyle(ChatFormatting.GREEN), true);
                                return;
                            }
                        }
                        entity.displayClientMessage((Component)Component.translatable((String)"tooltip.industrialforegoing.backpack.pickup_disabled").withStyle(ChatFormatting.RED), true);
                    } else {
                        ItemInfinityBackpack.sync(entity.level(), (String)id, entity);
                        IndustrialForegoing.NETWORK.get().sendTo((Object)new BackpackOpenedMessage(target.getSlot(), target.getName()), entity.connection.connection, NetworkDirection.PLAY_TO_CLIENT);
                        NetworkHooks.openScreen((ServerPlayer)entity, (MenuProvider)((ItemInfinityBackpack)ModuleTool.INFINITY_BACKPACK.get()), buffer -> LocatorFactory.writePacketBuffer((FriendlyByteBuf)buffer, (LocatorInstance)new InventoryStackLocatorInstance(target.getName(), target.getSlot())));
                        return;
                    }
                }
            });
        });
    }
}

