/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.proxy.block.filter;

import com.buuz135.industrial.gui.component.custom.ICanSendNetworkMessage;
import com.buuz135.industrial.gui.conveyor.GuiConveyor;
import com.buuz135.industrial.gui.transporter.GuiTransporter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public interface IFilter<T extends Entity> {
    public boolean acceptsInput(ItemStack var1);

    public boolean matches(T var1);

    public boolean matches(ItemStack var1);

    public boolean matches(FluidStack var1);

    public void setFilter(int var1, ItemStack var2);

    public GhostSlot[] getFilter();

    public CompoundTag serializeNBT();

    public void deserializeNBT(CompoundTag var1);

    public static class GhostSlot {
        public static final int MAX = 1024;
        public static final int MIN = 1;
        private final int x;
        private final int y;
        private int id;
        private ItemStack stack;
        private int amount;
        private int maxAmount;

        public GhostSlot(int id, int x, int y) {
            this.id = id;
            this.x = x;
            this.y = y;
            this.stack = ItemStack.EMPTY;
            this.amount = 1;
            this.maxAmount = 1024;
        }

        public ItemStack getStack() {
            return this.stack;
        }

        public void setStack(ItemStack stack) {
            this.stack = stack;
        }

        public void increaseAmount(int amount) {
            this.amount = Math.max(0, Math.min(this.maxAmount, this.amount + amount));
        }

        public void decreaseAmount(int amount) {
            this.amount = Math.max(1, this.amount - amount);
        }

        public int getAmount() {
            return this.amount;
        }

        public void setAmount(int amount) {
            this.amount = amount;
        }

        public void setMaxAmount(int maxAmount) {
            this.maxAmount = maxAmount;
        }

        public Rect2i getArea() {
            Screen screen = Minecraft.getInstance().screen;
            if (screen instanceof GuiConveyor) {
                GuiConveyor gui = (GuiConveyor)screen;
                return new Rect2i(this.x + gui.getX(), this.y + gui.getY(), 18, 18);
            }
            if (screen instanceof GuiTransporter) {
                GuiTransporter gui = (GuiTransporter)screen;
                return new Rect2i(this.x + gui.getX(), this.y + gui.getY(), 18, 18);
            }
            return new Rect2i(0, 0, 0, 0);
        }

        public void accept(ItemStack ingredient) {
            if (Minecraft.getInstance().screen instanceof ICanSendNetworkMessage) {
                ((ICanSendNetworkMessage)Minecraft.getInstance().screen).sendMessage(this.id, ingredient.serializeNBT());
            }
        }
    }
}

