/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.plugin.jei.category;

import com.buuz135.industrial.module.ModuleCore;
import com.buuz135.industrial.plugin.jei.IndustrialRecipeTypes;
import com.buuz135.industrial.recipe.FluidExtractorRecipe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.forge.ForgeTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.RegistryObject;

public class FluidExtractorCategory
implements IRecipeCategory<FluidExtractorRecipe> {
    private IGuiHelper guiHelper;
    private IDrawable tankOverlay;

    public FluidExtractorCategory(IGuiHelper guiHelper) {
        this.guiHelper = guiHelper;
        this.tankOverlay = guiHelper.createDrawable(new ResourceLocation("industrialforegoing", "textures/gui/jei.png"), 1, 207, 12, 48);
    }

    public RecipeType<FluidExtractorRecipe> getRecipeType() {
        return IndustrialRecipeTypes.FLUID_EXTRACTOR;
    }

    public Component getTitle() {
        return Component.translatable((String)((Block)((RegistryObject)ModuleCore.FLUID_EXTRACTOR.getLeft()).get()).getDescriptionId());
    }

    public IDrawable getBackground() {
        return this.guiHelper.drawableBuilder(new ResourceLocation("industrialforegoing", "textures/gui/jei.png"), 0, 27, 76, 50).addPadding(0, 0, 0, 74).build();
    }

    public IDrawable getIcon() {
        return null;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FluidExtractorRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 1, 17).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, new ArrayList(recipe.input.getItems()));
        ItemStack out = new ItemStack((ItemLike)recipe.result);
        if (!out.isEmpty()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, 27, 34).addIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)out)).setBackground((IDrawable)this.guiHelper.getSlotDrawable(), -1, -1);
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 57, 1).setFluidRenderer(20L, false, 12, 48).setOverlay(this.tankOverlay, 0, 0).addIngredient((IIngredientType)ForgeTypes.FLUID_STACK, (Object)recipe.output);
    }

    public void draw(FluidExtractorRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.drawString(Minecraft.getInstance().font, ChatFormatting.DARK_GRAY + "Production: ", 80, 6, 0xFFFFFF, false);
        Font font = Minecraft.getInstance().font;
        String string = ChatFormatting.DARK_GRAY + recipe.output.getAmount() + "mb/work";
        Objects.requireNonNull(Minecraft.getInstance().font);
        guiGraphics.drawString(font, string, 80, 6 + (9 + 2) * 1, 0xFFFFFF, false);
        Font font2 = Minecraft.getInstance().font;
        String string2 = ChatFormatting.DARK_AQUA + "Tripled when";
        Objects.requireNonNull(Minecraft.getInstance().font);
        guiGraphics.drawString(font2, string2, 80, 6 + (9 + 2) * 2, 0xFFFFFF, false);
        Font font3 = Minecraft.getInstance().font;
        String string3 = ChatFormatting.DARK_AQUA + "powered";
        Objects.requireNonNull(Minecraft.getInstance().font);
        guiGraphics.drawString(font3, string3, 80, 6 + (9 + 2) * 3, 0xFFFFFF, false);
    }

    public List<Component> getTooltipStrings(FluidExtractorRecipe recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX >= 78.0 && mouseX <= 140.0 && mouseY >= 5.0 && mouseY <= 25.0) {
            return Arrays.asList(Component.literal((String)"Production rate"));
        }
        return new ArrayList<Component>();
    }
}

