/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.gui.component;

import com.hrznstudio.titanium.api.client.IAsset;
import com.hrznstudio.titanium.api.client.IAssetType;
import com.hrznstudio.titanium.api.client.assets.types.ITankAsset;
import com.hrznstudio.titanium.client.screen.addon.BasicScreenAddon;
import com.hrznstudio.titanium.client.screen.asset.IAssetProvider;
import com.hrznstudio.titanium.component.fluid.FluidTankComponent;
import com.hrznstudio.titanium.util.AssetUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.Tags;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class ItemStackTankScreenAddon
extends BasicScreenAddon {
    private IFluidHandler tank;
    private ITankAsset asset;
    private FluidTankComponent.Type type;
    private int tankSlot;

    public ItemStackTankScreenAddon(int posX, int posY, IFluidHandler tank, int tankSlot, FluidTankComponent.Type type) {
        super(posX, posY);
        this.tank = tank;
        this.type = type;
        this.tankSlot = tankSlot;
    }

    public void drawBackgroundLayer(GuiGraphics guiGraphics, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
        this.asset = (ITankAsset)IAssetProvider.getAsset((IAssetProvider)provider, (IAssetType)this.type.getAssetType());
        Rectangle area = this.asset.getArea();
        if (!this.tank.getFluidInTank(this.tankSlot).isEmpty()) {
            TextureAtlasSprite sprite;
            AbstractTexture texture;
            FluidStack fluidStack = this.tank.getFluidInTank(this.tankSlot);
            int stored = fluidStack.getAmount();
            int capacity = this.tank.getTankCapacity(this.tankSlot);
            int topBottomPadding = this.asset.getFluidRenderPadding(Direction.UP) + this.asset.getFluidRenderPadding(Direction.DOWN);
            int offset = stored * (area.height - topBottomPadding) / capacity;
            IClientFluidTypeExtensions renderProperties = IClientFluidTypeExtensions.of((Fluid)fluidStack.getFluid());
            ResourceLocation flowing = renderProperties.getStillTexture(fluidStack);
            if (flowing != null && (texture = screen.getMinecraft().getTextureManager().getTexture(TextureAtlas.LOCATION_BLOCKS)) instanceof TextureAtlas && (sprite = ((TextureAtlas)texture).getSprite(flowing)) != null) {
                RenderSystem.setShaderTexture((int)0, (ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
                Color color = new Color(renderProperties.getTintColor());
                RenderSystem.setShaderColor((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
                RenderSystem.enableBlend();
                guiGraphics.blit(this.getPosX() + guiX + this.asset.getFluidRenderPadding(Direction.WEST), this.getPosY() + guiY + this.asset.getFluidRenderPadding(Direction.UP) + (fluidStack.getFluid().is(Tags.Fluids.GASEOUS) ? 0 : area.height - topBottomPadding - offset), 0, (int)(area.getWidth() - (double)this.asset.getFluidRenderPadding(Direction.EAST) - (double)this.asset.getFluidRenderPadding(Direction.WEST)), offset, sprite);
                RenderSystem.disableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ITankAsset asset = (ITankAsset)IAssetProvider.getAsset((IAssetProvider)provider, (IAssetType)this.type.getAssetType());
        AssetUtil.drawAsset((GuiGraphics)guiGraphics, (Screen)screen, (IAsset)asset, (int)(guiX + this.getPosX()), (int)(guiY + this.getPosY()));
    }

    public void drawForegroundLayer(GuiGraphics stack, Screen screen, IAssetProvider provider, int guiX, int guiY, int mouseX, int mouseY, float partialTicks) {
    }

    public List<Component> getTooltipLines() {
        ArrayList<Component> strings = new ArrayList<Component>();
        strings.add((Component)Component.literal((String)(ChatFormatting.GOLD + Component.translatable((String)"tooltip.titanium.tank.fluid").getString())).append((Component)(this.tank.getFluidInTank(this.tankSlot).isEmpty() ? Component.translatable((String)"tooltip.titanium.tank.empty").withStyle(ChatFormatting.WHITE) : Component.translatable((String)this.tank.getFluidInTank(this.tankSlot).getFluid().getFluidType().getDescriptionId()))).withStyle(ChatFormatting.WHITE));
        strings.add((Component)Component.translatable((String)"tooltip.titanium.tank.amount").withStyle(ChatFormatting.GOLD).append((Component)Component.literal((String)(ChatFormatting.WHITE + new DecimalFormat().format(this.tank.getFluidInTank(this.tankSlot).getAmount()) + ChatFormatting.GOLD + "/" + ChatFormatting.WHITE + new DecimalFormat().format(this.tank.getTankCapacity(this.tankSlot)) + ChatFormatting.DARK_AQUA + "mb"))));
        return strings;
    }

    public int getXSize() {
        return this.asset != null ? this.asset.getArea().width : 0;
    }

    public int getYSize() {
        return this.asset != null ? this.asset.getArea().height : 0;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return false;
    }
}

